/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Drawables;
import java.util.EnumSet;

class BrowserWebViewClient
extends WebViewClient {
    private static final EnumSet<UrlAction> SUPPORTED_URL_ACTIONS = EnumSet.of(UrlAction.HANDLE_PHONE_SCHEME, new UrlAction[]{UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
    @NonNull
    private MoPubBrowser mMoPubBrowser;

    public BrowserWebViewClient(@NonNull MoPubBrowser moPubBrowser) {
        this.mMoPubBrowser = moPubBrowser;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        MoPubLog.d("MoPubBrowser error: " + description);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        UrlHandler urlHandler = new UrlHandler.Builder().withSupportedUrlActions(SUPPORTED_URL_ACTIONS).withoutMoPubBrowser().withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(@NonNull String url, @NonNull UrlAction urlAction) {
                if (urlAction.equals((Object)UrlAction.OPEN_IN_APP_BROWSER)) {
                    BrowserWebViewClient.this.mMoPubBrowser.getWebView().loadUrl(url);
                } else {
                    BrowserWebViewClient.this.mMoPubBrowser.finish();
                }
            }

            @Override
            public void urlHandlingFailed(@NonNull String url, @NonNull UrlAction lastFailedUrlAction) {
            }
        }).build();
        return urlHandler.handleResolvedUrl(this.mMoPubBrowser.getApplicationContext(), url, true, null);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.mMoPubBrowser.getForwardButton().setImageDrawable(Drawables.UNRIGHT_ARROW.createDrawable((Context)this.mMoPubBrowser));
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        Drawable backImageDrawable = view.canGoBack() ? Drawables.LEFT_ARROW.createDrawable((Context)this.mMoPubBrowser) : Drawables.UNLEFT_ARROW.createDrawable((Context)this.mMoPubBrowser);
        this.mMoPubBrowser.getBackButton().setImageDrawable(backImageDrawable);
        Drawable forwardImageDrawable = view.canGoForward() ? Drawables.RIGHT_ARROW.createDrawable((Context)this.mMoPubBrowser) : Drawables.UNRIGHT_ARROW.createDrawable((Context)this.mMoPubBrowser);
        this.mMoPubBrowser.getForwardButton().setImageDrawable(forwardImageDrawable);
    }
}

