/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import com.mopub.common.VisibleForTesting;
import com.mopub.network.BackoffPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.NoConnectionError;
import com.mopub.volley.VolleyError;

public class ScribeBackoffPolicy
extends BackoffPolicy {
    private static final int DEFAULT_BACKOFF_TIME_MS = 60000;
    private static final int MAX_RETRIES = 5;
    private static final int BACKOFF_MULTIPLIER = 2;

    public ScribeBackoffPolicy() {
        this(60000, 5, 2);
    }

    @VisibleForTesting
    ScribeBackoffPolicy(int defaultBackoffTimeMs, int maxRetries, int backoffMultiplier) {
        this.mDefaultBackoffTimeMs = defaultBackoffTimeMs;
        this.mMaxRetries = maxRetries;
        this.mBackoffMultiplier = backoffMultiplier;
    }

    @Override
    public void backoff(VolleyError volleyError) throws VolleyError {
        if (!this.hasAttemptRemaining()) {
            throw volleyError;
        }
        if (volleyError instanceof NoConnectionError) {
            this.updateBackoffTime();
            return;
        }
        NetworkResponse networkResponse = volleyError.networkResponse;
        if (networkResponse != null && (networkResponse.statusCode == 503 || networkResponse.statusCode == 504)) {
            this.updateBackoffTime();
            return;
        }
        throw volleyError;
    }

    private void updateBackoffTime() {
        double multiplier = Math.pow(this.mBackoffMultiplier, this.mRetryCount);
        this.mBackoffMs = (int)((double)this.mDefaultBackoffTimeMs * multiplier);
        ++this.mRetryCount;
    }
}

