/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.net.SSLCertificateSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory mCertificateSocketFactory;

    private CustomSSLSocketFactory() {
    }

    public static CustomSSLSocketFactory getDefault(int handshakeTimeoutMillis) {
        CustomSSLSocketFactory factory = new CustomSSLSocketFactory();
        factory.mCertificateSocketFactory = SSLCertificateSocketFactory.getDefault((int)handshakeTimeoutMillis, null);
        return factory;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.mCertificateSocketFactory.createSocket();
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int i) throws IOException, UnknownHostException {
        Socket socket = this.mCertificateSocketFactory.createSocket(host, i);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localhost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.mCertificateSocketFactory.createSocket(host, port, localhost, localPort);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = this.mCertificateSocketFactory.createSocket(address, port);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localhost, int localPort) throws IOException {
        Socket socket = this.mCertificateSocketFactory.createSocket(address, port, localhost, localPort);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.mCertificateSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.mCertificateSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socketParam, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.mCertificateSocketFactory.createSocket(socketParam, host, port, autoClose);
        this.enableTlsIfAvailable(socket);
        return socket;
    }

    private void enableTlsIfAvailable(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            String[] supportedProtocols = sslSocket.getSupportedProtocols();
            sslSocket.setEnabledProtocols(supportedProtocols);
        }
    }
}

