/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class VisibilityTracker {
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;
    @VisibleForTesting
    static final int NUM_ACCESSES_BEFORE_TRIMMING = 50;
    @NonNull
    private final ArrayList<View> mTrimmedViews;
    private long mAccessCounter = 0L;
    @Nullable
    @VisibleForTesting
    ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;
    @NonNull
    @VisibleForTesting
    final WeakReference<View> mRootView;
    @NonNull
    private final Map<View, TrackingInfo> mTrackedViews;
    @NonNull
    private final VisibilityChecker mVisibilityChecker;
    @Nullable
    private VisibilityTrackerListener mVisibilityTrackerListener;
    @NonNull
    private final VisibilityRunnable mVisibilityRunnable;
    @NonNull
    private final Handler mVisibilityHandler;
    private boolean mIsVisibilityScheduled;

    public VisibilityTracker(@NonNull Context context) {
        this(context, new WeakHashMap<View, TrackingInfo>(10), new VisibilityChecker(), new Handler());
    }

    @VisibleForTesting
    VisibilityTracker(@NonNull Context context, @NonNull Map<View, TrackingInfo> trackedViews, @NonNull VisibilityChecker visibilityChecker, @NonNull Handler visibilityHandler) {
        this.mTrackedViews = trackedViews;
        this.mVisibilityChecker = visibilityChecker;
        this.mVisibilityHandler = visibilityHandler;
        this.mVisibilityRunnable = new VisibilityRunnable();
        this.mTrimmedViews = new ArrayList(50);
        View rootView = ((Activity)context).getWindow().getDecorView();
        this.mRootView = new WeakReference<View>(rootView);
        ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            MoPubLog.w("Visibility Tracker was unable to track views because the root view tree observer was not alive");
        } else {
            this.mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    VisibilityTracker.this.scheduleVisibilityCheck();
                    return true;
                }
            };
            viewTreeObserver.addOnPreDrawListener(this.mOnPreDrawListener);
        }
    }

    void setVisibilityTrackerListener(@Nullable VisibilityTrackerListener visibilityTrackerListener) {
        this.mVisibilityTrackerListener = visibilityTrackerListener;
    }

    void addView(@NonNull View view, int minPercentageViewed) {
        TrackingInfo trackingInfo = this.mTrackedViews.get(view);
        if (trackingInfo == null) {
            trackingInfo = new TrackingInfo();
            this.mTrackedViews.put(view, trackingInfo);
            this.scheduleVisibilityCheck();
        }
        trackingInfo.mMinViewablePercent = minPercentageViewed;
        trackingInfo.mAccessOrder = this.mAccessCounter++;
        if (this.mAccessCounter % 50L == 0L) {
            this.trimTrackedViews(this.mAccessCounter - 50L);
        }
    }

    private void trimTrackedViews(long minAccessOrder) {
        for (Map.Entry<View, TrackingInfo> entry : this.mTrackedViews.entrySet()) {
            if (entry.getValue().mAccessOrder >= minAccessOrder) continue;
            this.mTrimmedViews.add(entry.getKey());
        }
        for (View view : this.mTrimmedViews) {
            this.removeView(view);
        }
        this.mTrimmedViews.clear();
    }

    void removeView(@NonNull View view) {
        this.mTrackedViews.remove(view);
    }

    void clear() {
        this.mTrackedViews.clear();
        this.mVisibilityHandler.removeMessages(0);
        this.mIsVisibilityScheduled = false;
    }

    void destroy() {
        this.clear();
        View rootView = (View)this.mRootView.get();
        if (rootView != null && this.mOnPreDrawListener != null) {
            ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnPreDrawListener(this.mOnPreDrawListener);
            }
            this.mOnPreDrawListener = null;
        }
        this.mVisibilityTrackerListener = null;
    }

    void scheduleVisibilityCheck() {
        if (this.mIsVisibilityScheduled) {
            return;
        }
        this.mIsVisibilityScheduled = true;
        this.mVisibilityHandler.postDelayed((Runnable)this.mVisibilityRunnable, 100L);
    }

    static class VisibilityChecker {
        private final Rect mClipRect = new Rect();

        VisibilityChecker() {
        }

        boolean hasRequiredTimeElapsed(long startTimeMillis, int minTimeViewed) {
            return SystemClock.uptimeMillis() - startTimeMillis >= (long)minTimeViewed;
        }

        boolean isVisible(@Nullable View view, int minPercentageViewed) {
            if (view == null || view.getVisibility() != 0 || view.getParent() == null) {
                return false;
            }
            if (!view.getGlobalVisibleRect(this.mClipRect)) {
                return false;
            }
            long visibleViewArea = (long)this.mClipRect.height() * (long)this.mClipRect.width();
            long totalViewArea = (long)view.getHeight() * (long)view.getWidth();
            if (totalViewArea <= 0L) {
                return false;
            }
            return 100L * visibleViewArea >= (long)minPercentageViewed * totalViewArea;
        }
    }

    class VisibilityRunnable
    implements Runnable {
        @NonNull
        private final ArrayList<View> mVisibleViews;
        @NonNull
        private final ArrayList<View> mInvisibleViews = new ArrayList();

        VisibilityRunnable() {
            this.mVisibleViews = new ArrayList();
        }

        @Override
        public void run() {
            VisibilityTracker.this.mIsVisibilityScheduled = false;
            for (Map.Entry entry : VisibilityTracker.this.mTrackedViews.entrySet()) {
                View view = (View)entry.getKey();
                int minPercentageViewed = ((TrackingInfo)entry.getValue()).mMinViewablePercent;
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(view, minPercentageViewed)) {
                    this.mVisibleViews.add(view);
                    continue;
                }
                this.mInvisibleViews.add(view);
            }
            if (VisibilityTracker.this.mVisibilityTrackerListener != null) {
                VisibilityTracker.this.mVisibilityTrackerListener.onVisibilityChanged(this.mVisibleViews, this.mInvisibleViews);
            }
            this.mVisibleViews.clear();
            this.mInvisibleViews.clear();
        }
    }

    static class TrackingInfo {
        int mMinViewablePercent;
        long mAccessOrder;

        TrackingInfo() {
        }
    }

    static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }
}

