/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.nativeads.NativeAdData;
import java.util.List;

class PlacementData {
    public static final int NOT_FOUND = -1;
    private static final int MAX_ADS = 200;
    @NonNull
    private final int[] mDesiredOriginalPositions = new int[200];
    @NonNull
    private final int[] mDesiredInsertionPositions = new int[200];
    private int mDesiredCount = 0;
    @NonNull
    private final int[] mOriginalAdPositions = new int[200];
    @NonNull
    private final int[] mAdjustedAdPositions = new int[200];
    @NonNull
    private final NativeAdData[] mAdDataObjects = new NativeAdData[200];
    private int mPlacedCount = 0;

    private PlacementData(@NonNull int[] desiredInsertionPositions) {
        this.mDesiredCount = Math.min(desiredInsertionPositions.length, 200);
        System.arraycopy(desiredInsertionPositions, 0, this.mDesiredInsertionPositions, 0, this.mDesiredCount);
        System.arraycopy(desiredInsertionPositions, 0, this.mDesiredOriginalPositions, 0, this.mDesiredCount);
    }

    @NonNull
    static PlacementData fromAdPositioning(@NonNull MoPubNativeAdPositioning.MoPubClientPositioning adPositioning) {
        List<Integer> fixed = adPositioning.getFixedPositions();
        int interval = adPositioning.getRepeatingInterval();
        int size = interval == Integer.MAX_VALUE ? fixed.size() : 200;
        int[] desiredInsertionPositions = new int[size];
        int numAds = 0;
        int lastPos = 0;
        for (Integer position : fixed) {
            lastPos = position - numAds;
            desiredInsertionPositions[numAds++] = lastPos;
        }
        while (numAds < size) {
            lastPos = lastPos + interval - 1;
            desiredInsertionPositions[numAds++] = lastPos;
        }
        return new PlacementData(desiredInsertionPositions);
    }

    @NonNull
    static PlacementData empty() {
        return new PlacementData(new int[0]);
    }

    boolean shouldPlaceAd(int position) {
        int index = PlacementData.binarySearch(this.mDesiredInsertionPositions, 0, this.mDesiredCount, position);
        return index >= 0;
    }

    int nextInsertionPosition(int position) {
        int index = PlacementData.binarySearchGreaterThan(this.mDesiredInsertionPositions, this.mDesiredCount, position);
        if (index == this.mDesiredCount) {
            return -1;
        }
        return this.mDesiredInsertionPositions[index];
    }

    int previousInsertionPosition(int position) {
        int index = PlacementData.binarySearchFirstEquals(this.mDesiredInsertionPositions, this.mDesiredCount, position);
        if (index == 0) {
            return -1;
        }
        return this.mDesiredInsertionPositions[index - 1];
    }

    void placeAd(int adjustedPosition, NativeAdData adData) {
        int num;
        int desiredIndex = PlacementData.binarySearchFirstEquals(this.mDesiredInsertionPositions, this.mDesiredCount, adjustedPosition);
        if (desiredIndex == this.mDesiredCount || this.mDesiredInsertionPositions[desiredIndex] != adjustedPosition) {
            MoPubLog.w("Attempted to insert an ad at an invalid position");
            return;
        }
        int originalPosition = this.mDesiredOriginalPositions[desiredIndex];
        int placeIndex = PlacementData.binarySearchGreaterThan(this.mOriginalAdPositions, this.mPlacedCount, originalPosition);
        if (placeIndex < this.mPlacedCount) {
            num = this.mPlacedCount - placeIndex;
            System.arraycopy(this.mOriginalAdPositions, placeIndex, this.mOriginalAdPositions, placeIndex + 1, num);
            System.arraycopy(this.mAdjustedAdPositions, placeIndex, this.mAdjustedAdPositions, placeIndex + 1, num);
            System.arraycopy(this.mAdDataObjects, placeIndex, this.mAdDataObjects, placeIndex + 1, num);
        }
        this.mOriginalAdPositions[placeIndex] = originalPosition;
        this.mAdjustedAdPositions[placeIndex] = adjustedPosition;
        this.mAdDataObjects[placeIndex] = adData;
        ++this.mPlacedCount;
        num = this.mDesiredCount - desiredIndex - 1;
        System.arraycopy(this.mDesiredInsertionPositions, desiredIndex + 1, this.mDesiredInsertionPositions, desiredIndex, num);
        System.arraycopy(this.mDesiredOriginalPositions, desiredIndex + 1, this.mDesiredOriginalPositions, desiredIndex, num);
        --this.mDesiredCount;
        int i = desiredIndex;
        while (i < this.mDesiredCount) {
            int n = i++;
            this.mDesiredInsertionPositions[n] = this.mDesiredInsertionPositions[n] + 1;
        }
        i = placeIndex + 1;
        while (i < this.mPlacedCount) {
            int n = i++;
            this.mAdjustedAdPositions[n] = this.mAdjustedAdPositions[n] + 1;
        }
    }

    boolean isPlacedAd(int position) {
        int index = PlacementData.binarySearch(this.mAdjustedAdPositions, 0, this.mPlacedCount, position);
        return index >= 0;
    }

    @Nullable
    NativeAdData getPlacedAd(int position) {
        int index = PlacementData.binarySearch(this.mAdjustedAdPositions, 0, this.mPlacedCount, position);
        if (index < 0) {
            return null;
        }
        return this.mAdDataObjects[index];
    }

    @NonNull
    int[] getPlacedAdPositions() {
        int[] positions = new int[this.mPlacedCount];
        System.arraycopy(this.mAdjustedAdPositions, 0, positions, 0, this.mPlacedCount);
        return positions;
    }

    int getOriginalPosition(int position) {
        int index = PlacementData.binarySearch(this.mAdjustedAdPositions, 0, this.mPlacedCount, position);
        if (index < 0) {
            return position - ~index;
        }
        return -1;
    }

    int getAdjustedPosition(int originalPosition) {
        int index = PlacementData.binarySearchGreaterThan(this.mOriginalAdPositions, this.mPlacedCount, originalPosition);
        return originalPosition + index;
    }

    int getOriginalCount(int count) {
        if (count == 0) {
            return 0;
        }
        int originalPos = this.getOriginalPosition(count - 1);
        return originalPos == -1 ? -1 : originalPos + 1;
    }

    int getAdjustedCount(int originalCount) {
        if (originalCount == 0) {
            return 0;
        }
        return this.getAdjustedPosition(originalCount - 1) + 1;
    }

    int clearAdsInRange(int adjustedStartRange, int adjustedEndRange) {
        int i;
        int[] clearOriginalPositions = new int[this.mPlacedCount];
        int[] clearAdjustedPositions = new int[this.mPlacedCount];
        int clearCount = 0;
        for (int i2 = 0; i2 < this.mPlacedCount; ++i2) {
            int originalPosition = this.mOriginalAdPositions[i2];
            int adjustedPosition = this.mAdjustedAdPositions[i2];
            if (adjustedStartRange <= adjustedPosition && adjustedPosition < adjustedEndRange) {
                clearOriginalPositions[clearCount] = originalPosition;
                clearAdjustedPositions[clearCount] = adjustedPosition - clearCount;
                this.mAdDataObjects[i2].getAd().destroy();
                this.mAdDataObjects[i2] = null;
                ++clearCount;
                continue;
            }
            if (clearCount <= 0) continue;
            int newIndex = i2 - clearCount;
            this.mOriginalAdPositions[newIndex] = originalPosition;
            this.mAdjustedAdPositions[newIndex] = adjustedPosition - clearCount;
            this.mAdDataObjects[newIndex] = this.mAdDataObjects[i2];
        }
        if (clearCount == 0) {
            return 0;
        }
        int firstCleared = clearAdjustedPositions[0];
        int desiredIndex = PlacementData.binarySearchFirstEquals(this.mDesiredInsertionPositions, this.mDesiredCount, firstCleared);
        for (i = this.mDesiredCount - 1; i >= desiredIndex; --i) {
            this.mDesiredOriginalPositions[i + clearCount] = this.mDesiredOriginalPositions[i];
            this.mDesiredInsertionPositions[i + clearCount] = this.mDesiredInsertionPositions[i] - clearCount;
        }
        for (i = 0; i < clearCount; ++i) {
            this.mDesiredOriginalPositions[desiredIndex + i] = clearOriginalPositions[i];
            this.mDesiredInsertionPositions[desiredIndex + i] = clearAdjustedPositions[i];
        }
        this.mDesiredCount += clearCount;
        this.mPlacedCount -= clearCount;
        return clearCount;
    }

    void clearAds() {
        if (this.mPlacedCount == 0) {
            return;
        }
        this.clearAdsInRange(0, this.mAdjustedAdPositions[this.mPlacedCount - 1] + 1);
    }

    void insertItem(int originalPosition) {
        int indexToIncrement;
        int i = indexToIncrement = PlacementData.binarySearchFirstEquals(this.mDesiredOriginalPositions, this.mDesiredCount, originalPosition);
        while (i < this.mDesiredCount) {
            int n = i;
            this.mDesiredOriginalPositions[n] = this.mDesiredOriginalPositions[n] + 1;
            int n2 = i++;
            this.mDesiredInsertionPositions[n2] = this.mDesiredInsertionPositions[n2] + 1;
        }
        i = indexToIncrement = PlacementData.binarySearchFirstEquals(this.mOriginalAdPositions, this.mPlacedCount, originalPosition);
        while (i < this.mPlacedCount) {
            int n = i;
            this.mOriginalAdPositions[n] = this.mOriginalAdPositions[n] + 1;
            int n3 = i++;
            this.mAdjustedAdPositions[n3] = this.mAdjustedAdPositions[n3] + 1;
        }
    }

    void removeItem(int originalPosition) {
        int indexToDecrement;
        int i = indexToDecrement = PlacementData.binarySearchGreaterThan(this.mDesiredOriginalPositions, this.mDesiredCount, originalPosition);
        while (i < this.mDesiredCount) {
            int n = i;
            this.mDesiredOriginalPositions[n] = this.mDesiredOriginalPositions[n] - 1;
            int n2 = i++;
            this.mDesiredInsertionPositions[n2] = this.mDesiredInsertionPositions[n2] - 1;
        }
        i = indexToDecrement = PlacementData.binarySearchGreaterThan(this.mOriginalAdPositions, this.mPlacedCount, originalPosition);
        while (i < this.mPlacedCount) {
            int n = i;
            this.mOriginalAdPositions[n] = this.mOriginalAdPositions[n] - 1;
            int n3 = i++;
            this.mAdjustedAdPositions[n3] = this.mAdjustedAdPositions[n3] - 1;
        }
    }

    void moveItem(int originalPosition, int newPosition) {
        this.removeItem(originalPosition);
        this.insertItem(newPosition);
    }

    private static int binarySearchFirstEquals(int[] array, int count, int value) {
        int index = PlacementData.binarySearch(array, 0, count, value);
        if (index < 0) {
            return ~index;
        }
        int duplicateValue = array[index];
        while (index >= 0 && array[index] == duplicateValue) {
            --index;
        }
        return index + 1;
    }

    private static int binarySearchGreaterThan(int[] array, int count, int value) {
        int index = PlacementData.binarySearch(array, 0, count, value);
        if (index < 0) {
            return ~index;
        }
        int duplicateValue = array[index];
        while (index < count && array[index] == duplicateValue) {
            ++index;
        }
        return index;
    }

    private static int binarySearch(int[] array, int startIndex, int endIndex, int value) {
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }
}

