/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.ViewBinder;

class NativeViewHolder {
    @Nullable
    View mainView;
    @Nullable
    TextView titleView;
    @Nullable
    TextView textView;
    @Nullable
    TextView callToActionView;
    @Nullable
    ImageView mainImageView;
    @Nullable
    ImageView iconImageView;
    @VisibleForTesting
    static final NativeViewHolder EMPTY_VIEW_HOLDER = new NativeViewHolder();

    private NativeViewHolder() {
    }

    @NonNull
    static NativeViewHolder fromViewBinder(@NonNull View view, @NonNull ViewBinder viewBinder) {
        NativeViewHolder nativeViewHolder = new NativeViewHolder();
        nativeViewHolder.mainView = view;
        try {
            nativeViewHolder.titleView = (TextView)view.findViewById(viewBinder.titleId);
            nativeViewHolder.textView = (TextView)view.findViewById(viewBinder.textId);
            nativeViewHolder.callToActionView = (TextView)view.findViewById(viewBinder.callToActionId);
            nativeViewHolder.mainImageView = (ImageView)view.findViewById(viewBinder.mainImageId);
            nativeViewHolder.iconImageView = (ImageView)view.findViewById(viewBinder.iconImageId);
            return nativeViewHolder;
        }
        catch (ClassCastException exception) {
            MoPubLog.w("Could not cast from id in ViewBinder to expected View type", exception);
            return EMPTY_VIEW_HOLDER;
        }
    }

    void update(@NonNull NativeResponse nativeResponse) {
        this.addTextView(this.titleView, nativeResponse.getTitle());
        this.addTextView(this.textView, nativeResponse.getText());
        this.addTextView(this.callToActionView, nativeResponse.getCallToAction());
        nativeResponse.loadMainImage(this.mainImageView);
        nativeResponse.loadIconImage(this.iconImageView);
    }

    void updateExtras(@NonNull NativeResponse nativeResponse, @NonNull ViewBinder viewBinder) {
        if (this.mainView == null) {
            MoPubLog.w("Attempted to bind extras on a null main view.");
            return;
        }
        for (String key : viewBinder.extras.keySet()) {
            int resourceId = viewBinder.extras.get(key);
            View view = this.mainView.findViewById(resourceId);
            Object content = nativeResponse.getExtra(key);
            if (view instanceof ImageView) {
                ((ImageView)view).setImageDrawable(null);
                nativeResponse.loadExtrasImage(key, (ImageView)view);
                continue;
            }
            if (view instanceof TextView) {
                ((TextView)view).setText(null);
                if (!(content instanceof String)) continue;
                this.addTextView((TextView)view, (String)content);
                continue;
            }
            MoPubLog.d("View bound to " + key + " should be an instance of TextView or ImageView.");
        }
    }

    private void addTextView(@Nullable TextView textView, @Nullable String contents) {
        if (textView == null) {
            MoPubLog.d("Attempted to add text (" + contents + ") to null TextView.");
            return;
        }
        textView.setText(null);
        if (contents == null) {
            MoPubLog.d("Attempted to set TextView contents to null.");
        } else {
            textView.setText((CharSequence)contents);
        }
    }

    public void setViewVisibility(int visibility) {
        if (this.mainView != null) {
            this.mainView.setVisibility(visibility);
        }
    }
}

