/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.nativeads.RequestParameters;

class NativeUrlGenerator
extends AdUrlGenerator {
    @Nullable
    private String mDesiredAssets;
    @Nullable
    private String mSequenceNumber;

    NativeUrlGenerator(Context context) {
        super(context);
    }

    @Override
    @NonNull
    public NativeUrlGenerator withAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    @NonNull
    NativeUrlGenerator withRequest(@Nullable RequestParameters requestParameters) {
        if (requestParameters != null) {
            this.mKeywords = requestParameters.getKeywords();
            this.mLocation = requestParameters.getLocation();
            this.mDesiredAssets = requestParameters.getDesiredAssets();
        }
        return this;
    }

    @NonNull
    NativeUrlGenerator withSequenceNumber(int sequenceNumber) {
        this.mSequenceNumber = String.valueOf(sequenceNumber);
        return this;
    }

    @Override
    public String generateUrlString(String serverHostname) {
        this.initUrlString(serverHostname, "/m/ad");
        ClientMetadata clientMetadata = ClientMetadata.getInstance(this.mContext);
        this.addBaseParams(clientMetadata);
        this.setDesiredAssets();
        this.setSequenceNumber();
        return this.getFinalUrlString();
    }

    private void setSequenceNumber() {
        if (!TextUtils.isEmpty((CharSequence)this.mSequenceNumber)) {
            this.addParam("MAGIC_NO", this.mSequenceNumber);
        }
    }

    private void setDesiredAssets() {
        if (!TextUtils.isEmpty((CharSequence)this.mDesiredAssets)) {
            this.addParam("assets", this.mDesiredAssets);
        }
    }

    @Override
    protected void setSdkVersion(String sdkVersion) {
        this.addParam("nsv", sdkVersion);
    }
}

