/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.ImpressionTracker;
import com.mopub.nativeads.MoPubNativeAdRenderer;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.ViewBinder;
import java.util.WeakHashMap;

@Deprecated
class NativeAdViewHelper {
    @VisibleForTesting
    static final WeakHashMap<Context, ImpressionTracker> sImpressionTrackerMap = new WeakHashMap();
    private static final WeakHashMap<View, NativeResponse> sNativeResponseMap = new WeakHashMap();

    private NativeAdViewHelper() {
    }

    @Deprecated
    @NonNull
    static View getAdView(@Nullable View convertView, @Nullable ViewGroup parent, @NonNull Context context, @Nullable NativeResponse nativeResponse, @Nullable ViewBinder viewBinder) {
        Preconditions.NoThrow.checkNotNull(viewBinder, "ViewBinder is null.");
        if (convertView != null) {
            NativeAdViewHelper.clearNativeResponse(context, convertView);
        }
        if (nativeResponse == null || nativeResponse.isDestroyed() || viewBinder == null) {
            MoPubLog.d("nativeResponse or viewBinder null or invalid. Returning empty view");
            if (convertView == null || !ViewType.EMPTY.equals(convertView.getTag())) {
                convertView = new View(context);
                convertView.setTag((Object)ViewType.EMPTY);
                convertView.setVisibility(8);
            }
        } else {
            MoPubNativeAdRenderer moPubNativeAdRenderer = new MoPubNativeAdRenderer(viewBinder);
            if (convertView == null || !ViewType.AD.equals(convertView.getTag())) {
                convertView = moPubNativeAdRenderer.createAdView(context, parent);
                convertView.setTag((Object)ViewType.AD);
            }
            NativeAdViewHelper.prepareNativeResponse(context, convertView, nativeResponse);
            moPubNativeAdRenderer.renderAdView(convertView, nativeResponse);
        }
        return convertView;
    }

    private static void clearNativeResponse(@NonNull Context context, @NonNull View view) {
        NativeAdViewHelper.getImpressionTracker(context).removeView(view);
        NativeResponse nativeResponse = sNativeResponseMap.get(view);
        if (nativeResponse != null) {
            nativeResponse.clear(view);
        }
    }

    private static void prepareNativeResponse(@NonNull Context context, @NonNull View view, @NonNull NativeResponse nativeResponse) {
        sNativeResponseMap.put(view, nativeResponse);
        if (!nativeResponse.isOverridingImpressionTracker()) {
            NativeAdViewHelper.getImpressionTracker(context).addView(view, nativeResponse);
        }
        nativeResponse.prepare(view);
    }

    private static ImpressionTracker getImpressionTracker(@NonNull Context context) {
        ImpressionTracker impressionTracker = sImpressionTrackerMap.get(context);
        if (impressionTracker == null) {
            impressionTracker = new ImpressionTracker(context);
            sImpressionTrackerMap.put(context, impressionTracker);
        }
        return impressionTracker;
    }

    @VisibleForTesting
    static enum ViewType {
        EMPTY,
        AD;

    }
}

