/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.MoPubNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.RequestParameters;
import com.mopub.nativeads.TimestampWrapper;
import java.util.ArrayList;
import java.util.List;

class NativeAdSource {
    private static final int CACHE_LIMIT = 3;
    private static final int EXPIRATION_TIME_MILLISECONDS = 900000;
    private static final int DEFAULT_RETRY_TIME_MILLISECONDS = 1000;
    private static final int MAXIMUM_RETRY_TIME_MILLISECONDS = 300000;
    private static final double EXPONENTIAL_BACKOFF_FACTOR = 2.0;
    @NonNull
    private final List<TimestampWrapper<NativeResponse>> mNativeAdCache;
    @NonNull
    private final Handler mReplenishCacheHandler;
    @NonNull
    private final Runnable mReplenishCacheRunnable;
    @NonNull
    private final MoPubNative.MoPubNativeNetworkListener mMoPubNativeNetworkListener;
    @VisibleForTesting
    boolean mRequestInFlight;
    @VisibleForTesting
    boolean mRetryInFlight;
    @VisibleForTesting
    int mSequenceNumber;
    @VisibleForTesting
    int mRetryTimeMilliseconds;
    @Nullable
    private AdSourceListener mAdSourceListener;
    @Nullable
    private RequestParameters mRequestParameters;
    @Nullable
    private MoPubNative mMoPubNative;

    NativeAdSource() {
        this(new ArrayList<TimestampWrapper<NativeResponse>>(3), new Handler());
    }

    @VisibleForTesting
    NativeAdSource(@NonNull List<TimestampWrapper<NativeResponse>> nativeAdCache, @NonNull Handler replenishCacheHandler) {
        this.mNativeAdCache = nativeAdCache;
        this.mReplenishCacheHandler = replenishCacheHandler;
        this.mReplenishCacheRunnable = new Runnable(){

            @Override
            public void run() {
                NativeAdSource.this.mRetryInFlight = false;
                NativeAdSource.this.replenishCache();
            }
        };
        this.mMoPubNativeNetworkListener = new MoPubNative.MoPubNativeNetworkListener(){

            @Override
            public void onNativeLoad(@NonNull NativeResponse nativeResponse) {
                if (NativeAdSource.this.mMoPubNative == null) {
                    return;
                }
                NativeAdSource.this.mRequestInFlight = false;
                ++NativeAdSource.this.mSequenceNumber;
                NativeAdSource.this.resetRetryTime();
                NativeAdSource.this.mNativeAdCache.add(new TimestampWrapper<NativeResponse>(nativeResponse));
                if (NativeAdSource.this.mNativeAdCache.size() == 1 && NativeAdSource.this.mAdSourceListener != null) {
                    NativeAdSource.this.mAdSourceListener.onAdsAvailable();
                }
                NativeAdSource.this.replenishCache();
            }

            @Override
            public void onNativeFail(NativeErrorCode errorCode) {
                NativeAdSource.this.mRequestInFlight = false;
                if (NativeAdSource.this.mRetryTimeMilliseconds >= 300000) {
                    NativeAdSource.this.resetRetryTime();
                    return;
                }
                NativeAdSource.this.updateRetryTime();
                NativeAdSource.this.mRetryInFlight = true;
                NativeAdSource.this.mReplenishCacheHandler.postDelayed(NativeAdSource.this.mReplenishCacheRunnable, (long)NativeAdSource.this.mRetryTimeMilliseconds);
            }
        };
        this.mSequenceNumber = 0;
        this.mRetryTimeMilliseconds = 1000;
    }

    void setAdSourceListener(@Nullable AdSourceListener adSourceListener) {
        this.mAdSourceListener = adSourceListener;
    }

    void loadAds(@NonNull Context context, @NonNull String adUnitId, RequestParameters requestParameters) {
        this.loadAds(requestParameters, new MoPubNative(context, adUnitId, this.mMoPubNativeNetworkListener));
    }

    @VisibleForTesting
    void loadAds(RequestParameters requestParameters, MoPubNative moPubNative) {
        this.clear();
        this.mRequestParameters = requestParameters;
        this.mMoPubNative = moPubNative;
        this.replenishCache();
    }

    void clear() {
        if (this.mMoPubNative != null) {
            this.mMoPubNative.destroy();
            this.mMoPubNative = null;
        }
        this.mRequestParameters = null;
        for (TimestampWrapper<NativeResponse> timestampWrapper : this.mNativeAdCache) {
            ((NativeResponse)timestampWrapper.mInstance).destroy();
        }
        this.mNativeAdCache.clear();
        this.mReplenishCacheHandler.removeMessages(0);
        this.mRequestInFlight = false;
        this.mSequenceNumber = 0;
        this.resetRetryTime();
    }

    @Nullable
    NativeResponse dequeueAd() {
        long now = SystemClock.uptimeMillis();
        if (!this.mRequestInFlight && !this.mRetryInFlight) {
            this.mReplenishCacheHandler.post(this.mReplenishCacheRunnable);
        }
        while (!this.mNativeAdCache.isEmpty()) {
            TimestampWrapper<NativeResponse> responseWrapper = this.mNativeAdCache.remove(0);
            if (now - responseWrapper.mCreatedTimestamp >= 900000L) continue;
            return (NativeResponse)responseWrapper.mInstance;
        }
        return null;
    }

    @VisibleForTesting
    void updateRetryTime() {
        this.mRetryTimeMilliseconds = (int)((double)this.mRetryTimeMilliseconds * 2.0);
        if (this.mRetryTimeMilliseconds > 300000) {
            this.mRetryTimeMilliseconds = 300000;
        }
    }

    @VisibleForTesting
    void resetRetryTime() {
        this.mRetryTimeMilliseconds = 1000;
    }

    @VisibleForTesting
    void replenishCache() {
        if (!this.mRequestInFlight && this.mMoPubNative != null && this.mNativeAdCache.size() < 3) {
            this.mRequestInFlight = true;
            this.mMoPubNative.makeRequest(this.mRequestParameters, this.mSequenceNumber);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setMoPubNative(MoPubNative moPubNative) {
        this.mMoPubNative = moPubNative;
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    MoPubNative.MoPubNativeNetworkListener getMoPubNativeNetworkListener() {
        return this.mMoPubNativeNetworkListener;
    }

    static interface AdSourceListener {
        public void onAdsAvailable();
    }
}

