/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.NativeViewHolder;
import com.mopub.nativeads.ViewBinder;
import java.util.WeakHashMap;

public class MoPubNativeAdRenderer
implements MoPubAdRenderer<NativeResponse> {
    @NonNull
    private final ViewBinder mViewBinder;
    @VisibleForTesting
    @NonNull
    final WeakHashMap<View, NativeViewHolder> mViewHolderMap;

    public MoPubNativeAdRenderer(@NonNull ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
        this.mViewHolderMap = new WeakHashMap();
    }

    @Override
    @NonNull
    public View createAdView(@NonNull Context context, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)context).inflate(this.mViewBinder.layoutId, parent, false);
    }

    @Override
    public void renderAdView(@NonNull View view, @NonNull NativeResponse nativeResponse) {
        NativeViewHolder nativeViewHolder = this.mViewHolderMap.get(view);
        if (nativeViewHolder == null) {
            nativeViewHolder = NativeViewHolder.fromViewBinder(view, this.mViewBinder);
            this.mViewHolderMap.put(view, nativeViewHolder);
        }
        nativeViewHolder.update(nativeResponse);
        nativeViewHolder.updateExtras(nativeResponse, this.mViewBinder);
        nativeViewHolder.setViewVisibility(0);
    }
}

