/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.AdFormat;
import com.mopub.common.GpsHelper;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.ManifestUtils;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.CustomEventNativeAdapter;
import com.mopub.nativeads.NativeAdInterface;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.NativeUrlGenerator;
import com.mopub.nativeads.RequestParameters;
import com.mopub.network.AdRequest;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.Networking;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.VolleyError;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.TreeMap;

public class MoPubNative {
    static final MoPubNativeNetworkListener EMPTY_NETWORK_LISTENER = new MoPubNativeNetworkListener(){

        @Override
        public void onNativeLoad(@NonNull NativeResponse nativeResponse) {
            nativeResponse.destroy();
        }

        @Override
        public void onNativeFail(NativeErrorCode errorCode) {
        }
    };
    static final MoPubNativeEventListener EMPTY_EVENT_LISTENER = new MoPubNativeEventListener(){

        @Override
        public void onNativeImpression(@Nullable View view) {
        }

        @Override
        public void onNativeClick(@Nullable View view) {
        }
    };
    @NonNull
    private final WeakReference<Context> mContext;
    @NonNull
    private final String mAdUnitId;
    @NonNull
    private MoPubNativeNetworkListener mMoPubNativeNetworkListener;
    @NonNull
    private MoPubNativeEventListener mMoPubNativeEventListener;
    @NonNull
    private Map<String, Object> mLocalExtras = new TreeMap<String, Object>();
    @NonNull
    private final AdRequest.Listener mVolleyListener;
    @Nullable
    private AdRequest mNativeRequest;

    @Deprecated
    public MoPubNative(@NonNull Context context, @NonNull String adUnitId, @NonNull MoPubNativeListener moPubNativeListener) {
        this(context, adUnitId, (MoPubNativeNetworkListener)moPubNativeListener);
        this.setNativeEventListener(moPubNativeListener);
    }

    public MoPubNative(@NonNull Context context, @NonNull String adUnitId, @NonNull MoPubNativeNetworkListener moPubNativeNetworkListener) {
        Preconditions.checkNotNull(context, "Context may not be null.");
        Preconditions.checkNotNull(adUnitId, "AdUnitId may not be null.");
        Preconditions.checkNotNull(moPubNativeNetworkListener, "MoPubNativeNetworkListener may not be null.");
        ManifestUtils.checkNativeActivitiesDeclared(context);
        this.mContext = new WeakReference<Context>(context);
        this.mAdUnitId = adUnitId;
        this.mMoPubNativeNetworkListener = moPubNativeNetworkListener;
        this.mMoPubNativeEventListener = EMPTY_EVENT_LISTENER;
        this.mVolleyListener = new AdRequest.Listener(){

            @Override
            public void onSuccess(@NonNull AdResponse response) {
                MoPubNative.this.onAdLoad(response);
            }

            public void onErrorResponse(@NonNull VolleyError volleyError) {
                MoPubNative.this.onAdError(volleyError);
            }
        };
        GpsHelper.fetchAdvertisingInfoAsync(context, null);
    }

    public void setNativeEventListener(@Nullable MoPubNativeEventListener nativeEventListener) {
        this.mMoPubNativeEventListener = nativeEventListener == null ? EMPTY_EVENT_LISTENER : nativeEventListener;
    }

    public void destroy() {
        this.mContext.clear();
        if (this.mNativeRequest != null) {
            this.mNativeRequest.cancel();
            this.mNativeRequest = null;
        }
        this.mMoPubNativeNetworkListener = EMPTY_NETWORK_LISTENER;
        this.mMoPubNativeEventListener = EMPTY_EVENT_LISTENER;
    }

    public void setLocalExtras(@Nullable Map<String, Object> localExtras) {
        this.mLocalExtras = localExtras == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(localExtras);
    }

    public void makeRequest() {
        this.makeRequest(null);
    }

    public void makeRequest(@Nullable RequestParameters requestParameters) {
        this.makeRequest(requestParameters, null);
    }

    public void makeRequest(@Nullable RequestParameters requestParameters, @Nullable Integer sequenceNumber) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        if (!DeviceUtils.isNetworkAvailable(context)) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.CONNECTION_ERROR);
            return;
        }
        this.loadNativeAd(requestParameters, sequenceNumber);
    }

    private void loadNativeAd(@Nullable RequestParameters requestParameters, @Nullable Integer sequenceNumber) {
        String endpointUrl;
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        NativeUrlGenerator generator = new NativeUrlGenerator(context).withAdUnitId(this.mAdUnitId).withRequest(requestParameters);
        if (sequenceNumber != null) {
            generator.withSequenceNumber(sequenceNumber);
        }
        if ((endpointUrl = generator.generateUrlString("ads.mopub.com")) != null) {
            MoPubLog.d("Loading ad from: " + endpointUrl);
        }
        this.requestNativeAd(endpointUrl);
    }

    void requestNativeAd(@Nullable String endpointUrl) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        if (endpointUrl == null) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_REQUEST_URL);
            return;
        }
        this.mNativeRequest = new AdRequest(endpointUrl, AdFormat.NATIVE, this.mAdUnitId, context, this.mVolleyListener);
        MoPubRequestQueue requestQueue = Networking.getRequestQueue(context);
        requestQueue.add(this.mNativeRequest);
    }

    private void onAdLoad(final @NonNull AdResponse response) {
        Context context = this.getContextOrDestroy();
        if (context == null) {
            return;
        }
        CustomEventNative.CustomEventNativeListener customEventNativeListener = new CustomEventNative.CustomEventNativeListener(){

            @Override
            public void onNativeAdLoaded(@NonNull NativeAdInterface nativeAd) {
                Context context = MoPubNative.this.getContextOrDestroy();
                if (context == null) {
                    return;
                }
                MoPubNative.this.mMoPubNativeNetworkListener.onNativeLoad(new NativeResponse(context, response.getImpressionTrackingUrl(), response.getClickTrackingUrl(), MoPubNative.this.mAdUnitId, nativeAd, MoPubNative.this.mMoPubNativeEventListener));
            }

            @Override
            public void onNativeAdFailed(NativeErrorCode errorCode) {
                MoPubNative.this.requestNativeAd(response.getFailoverUrl());
            }
        };
        CustomEventNativeAdapter.loadNativeAd(context, this.mLocalExtras, response, customEventNativeListener);
    }

    @VisibleForTesting
    void onAdError(@NonNull VolleyError volleyError) {
        MoPubLog.d("Native ad request failed.", (Throwable)volleyError);
        if (volleyError instanceof MoPubNetworkError) {
            MoPubNetworkError error = (MoPubNetworkError)volleyError;
            switch (error.getReason()) {
                case BAD_BODY: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_JSON);
                    return;
                }
                case BAD_HEADER_DATA: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.INVALID_JSON);
                    return;
                }
                case WARMING_UP: {
                    MoPubLog.c(MoPubErrorCode.WARMUP.toString());
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.EMPTY_AD_RESPONSE);
                    return;
                }
                case NO_FILL: {
                    this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.EMPTY_AD_RESPONSE);
                    return;
                }
            }
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.UNSPECIFIED);
            return;
        }
        NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.statusCode >= 500 && response.statusCode < 600) {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.SERVER_ERROR_RESPONSE_CODE);
        } else if (response == null && !DeviceUtils.isNetworkAvailable((Context)this.mContext.get())) {
            MoPubLog.c(String.valueOf(MoPubErrorCode.NO_CONNECTION.toString()));
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.CONNECTION_ERROR);
        } else {
            this.mMoPubNativeNetworkListener.onNativeFail(NativeErrorCode.UNSPECIFIED);
        }
    }

    Context getContextOrDestroy() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            this.destroy();
            MoPubLog.d("Weak reference to Activity Context in MoPubNative became null. This instance of MoPubNative is destroyed and No more requests will be processed.");
        }
        return context;
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    MoPubNativeNetworkListener getMoPubNativeNetworkListener() {
        return this.mMoPubNativeNetworkListener;
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    MoPubNativeEventListener getMoPubNativeEventListener() {
        return this.mMoPubNativeEventListener;
    }

    @Deprecated
    public static interface MoPubNativeListener
    extends MoPubNativeNetworkListener,
    MoPubNativeEventListener {
    }

    public static interface MoPubNativeEventListener {
        public void onNativeImpression(View var1);

        public void onNativeClick(View var1);
    }

    public static interface MoPubNativeNetworkListener {
        public void onNativeLoad(NativeResponse var1);

        public void onNativeFail(NativeErrorCode var1);
    }
}

