/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Numbers;
import com.mopub.nativeads.BaseForwardingNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubCustomEventNative
extends CustomEventNative {
    @Override
    protected void loadNativeAd(@NonNull Context context, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        Object json = localExtras.get("com_mopub_native_json");
        if (!(json instanceof JSONObject)) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_JSON);
            return;
        }
        MoPubForwardingNativeAd moPubForwardingNativeAd = new MoPubForwardingNativeAd(context.getApplicationContext(), (JSONObject)json, customEventNativeListener);
        try {
            moPubForwardingNativeAd.loadAd();
        }
        catch (IllegalArgumentException e) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
        }
    }

    static class MoPubForwardingNativeAd
    extends BaseForwardingNativeAd {
        @NonNull
        private final Context mContext;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final JSONObject mJsonObject;

        MoPubForwardingNativeAd(@NonNull Context context, @NonNull JSONObject jsonBody, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.mJsonObject = jsonBody;
            this.mContext = context;
            this.mCustomEventNativeListener = customEventNativeListener;
        }

        void loadAd() throws IllegalArgumentException {
            if (!this.containsRequiredKeys(this.mJsonObject)) {
                throw new IllegalArgumentException("JSONObject did not contain required keys.");
            }
            Iterator keys = this.mJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                NativeResponse.Parameter parameter = NativeResponse.Parameter.from(key);
                if (parameter != null) {
                    try {
                        this.addInstanceVariable(parameter, this.mJsonObject.opt(key));
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("JSONObject key (" + key + ") contained unexpected value.");
                    }
                }
                this.addExtra(key, this.mJsonObject.opt(key));
            }
            MoPubForwardingNativeAd.preCacheImages(this.mContext, this.getAllImageUrls(), new CustomEventNative.ImageListener(){

                @Override
                public void onImagesCached() {
                    MoPubForwardingNativeAd.this.mCustomEventNativeListener.onNativeAdLoaded(MoPubForwardingNativeAd.this);
                }

                @Override
                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    MoPubForwardingNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(errorCode);
                }
            });
        }

        private boolean containsRequiredKeys(@NonNull JSONObject jsonObject) {
            HashSet keys = new HashSet();
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                keys.add(jsonKeys.next());
            }
            return keys.containsAll(NativeResponse.Parameter.requiredKeys);
        }

        private void addInstanceVariable(@NonNull NativeResponse.Parameter key, @Nullable Object value) throws ClassCastException {
            try {
                switch (key) {
                    case MAIN_IMAGE: {
                        this.setMainImageUrl((String)value);
                        break;
                    }
                    case ICON_IMAGE: {
                        this.setIconImageUrl((String)value);
                        break;
                    }
                    case IMPRESSION_TRACKER: {
                        this.addImpressionTrackers(value);
                        break;
                    }
                    case CLICK_TRACKER: {
                        break;
                    }
                    case CLICK_DESTINATION: {
                        this.setClickDestinationUrl((String)value);
                        break;
                    }
                    case CALL_TO_ACTION: {
                        this.setCallToAction((String)value);
                        break;
                    }
                    case TITLE: {
                        this.setTitle((String)value);
                        break;
                    }
                    case TEXT: {
                        this.setText((String)value);
                        break;
                    }
                    case STAR_RATING: {
                        this.setStarRating(Numbers.parseDouble(value));
                        break;
                    }
                    default: {
                        MoPubLog.d("Unable to add JSON key to internal mapping: " + key.name);
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                if (!key.required) {
                    MoPubLog.d("Ignoring class cast exception for optional key: " + key.name);
                }
                throw e;
            }
        }

        private void addImpressionTrackers(Object impressionTrackers) throws ClassCastException {
            if (!(impressionTrackers instanceof JSONArray)) {
                throw new ClassCastException("Expected impression trackers of type JSONArray.");
            }
            JSONArray trackers = (JSONArray)impressionTrackers;
            for (int i = 0; i < trackers.length(); ++i) {
                try {
                    this.addImpressionTracker(trackers.getString(i));
                    continue;
                }
                catch (JSONException e) {
                    MoPubLog.d("Unable to parse impression trackers.");
                }
            }
        }

        private boolean isImageKey(@Nullable String name) {
            return name != null && name.toLowerCase(Locale.US).endsWith("image");
        }

        @NonNull
        List<String> getExtrasImageUrls() {
            ArrayList<String> extrasBitmapUrls = new ArrayList<String>(this.getExtras().size());
            for (Map.Entry<String, Object> entry : this.getExtras().entrySet()) {
                if (!this.isImageKey(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
                extrasBitmapUrls.add((String)entry.getValue());
            }
            return extrasBitmapUrls;
        }

        @NonNull
        List<String> getAllImageUrls() {
            ArrayList<String> imageUrls = new ArrayList<String>();
            if (this.getMainImageUrl() != null) {
                imageUrls.add(this.getMainImageUrl());
            }
            if (this.getIconImageUrl() != null) {
                imageUrls.add(this.getIconImageUrl());
            }
            imageUrls.addAll(this.getExtrasImageUrls());
            return imageUrls;
        }
    }
}

