/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.MoPubNativeAdLoadedListener;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.nativeads.MoPubNativeAdRenderer;
import com.mopub.nativeads.MoPubStreamAdPlacer;
import com.mopub.nativeads.RequestParameters;
import com.mopub.nativeads.ViewBinder;
import com.mopub.nativeads.VisibilityTracker;
import java.util.List;
import java.util.WeakHashMap;

public class MoPubAdAdapter
extends BaseAdapter {
    @NonNull
    private final WeakHashMap<View, Integer> mViewPositionMap;
    @NonNull
    private final Adapter mOriginalAdapter;
    @NonNull
    private final MoPubStreamAdPlacer mStreamAdPlacer;
    @NonNull
    private final VisibilityTracker mVisibilityTracker;
    @Nullable
    private MoPubNativeAdLoadedListener mAdLoadedListener;

    public MoPubAdAdapter(@NonNull Context context, @NonNull Adapter originalAdapter) {
        this(context, originalAdapter, MoPubNativeAdPositioning.serverPositioning());
    }

    public MoPubAdAdapter(@NonNull Context context, @NonNull Adapter originalAdapter, @NonNull MoPubNativeAdPositioning.MoPubServerPositioning adPositioning) {
        this(new MoPubStreamAdPlacer(context, adPositioning), originalAdapter, new VisibilityTracker(context));
    }

    public MoPubAdAdapter(@NonNull Context context, @NonNull Adapter originalAdapter, @NonNull MoPubNativeAdPositioning.MoPubClientPositioning adPositioning) {
        this(new MoPubStreamAdPlacer(context, adPositioning), originalAdapter, new VisibilityTracker(context));
    }

    @VisibleForTesting
    MoPubAdAdapter(@NonNull MoPubStreamAdPlacer streamAdPlacer, @NonNull Adapter originalAdapter, @NonNull VisibilityTracker visibilityTracker) {
        this.mOriginalAdapter = originalAdapter;
        this.mStreamAdPlacer = streamAdPlacer;
        this.mViewPositionMap = new WeakHashMap();
        this.mVisibilityTracker = visibilityTracker;
        this.mVisibilityTracker.setVisibilityTrackerListener(new VisibilityTracker.VisibilityTrackerListener(){

            @Override
            public void onVisibilityChanged(@NonNull List<View> visibleViews, List<View> invisibleViews) {
                MoPubAdAdapter.this.handleVisibilityChange(visibleViews);
            }
        });
        this.mOriginalAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                MoPubAdAdapter.this.mStreamAdPlacer.setItemCount(MoPubAdAdapter.this.mOriginalAdapter.getCount());
                MoPubAdAdapter.this.notifyDataSetChanged();
            }

            public void onInvalidated() {
                MoPubAdAdapter.this.notifyDataSetInvalidated();
            }
        });
        this.mStreamAdPlacer.setAdLoadedListener(new MoPubNativeAdLoadedListener(){

            @Override
            public void onAdLoaded(int position) {
                MoPubAdAdapter.this.handleAdLoaded(position);
            }

            @Override
            public void onAdRemoved(int position) {
                MoPubAdAdapter.this.handleAdRemoved(position);
            }
        });
        this.mStreamAdPlacer.setItemCount(this.mOriginalAdapter.getCount());
    }

    @VisibleForTesting
    void handleAdLoaded(int position) {
        if (this.mAdLoadedListener != null) {
            this.mAdLoadedListener.onAdLoaded(position);
        }
        this.notifyDataSetChanged();
    }

    @VisibleForTesting
    void handleAdRemoved(int position) {
        if (this.mAdLoadedListener != null) {
            this.mAdLoadedListener.onAdRemoved(position);
        }
        this.notifyDataSetChanged();
    }

    @Deprecated
    public final void registerAdRenderer(@NonNull MoPubAdRenderer adRenderer) {
        if (!Preconditions.NoThrow.checkNotNull(adRenderer, "Tried to set a null ad renderer on the placer.")) {
            return;
        }
        this.mStreamAdPlacer.registerAdRenderer(adRenderer);
    }

    public final void registerViewBinder(@NonNull ViewBinder viewBinder) {
        if (!Preconditions.NoThrow.checkNotNull(viewBinder, "Tried to set a null view binder on the placer.")) {
            return;
        }
        this.mStreamAdPlacer.registerAdRenderer(new MoPubNativeAdRenderer(viewBinder));
    }

    public final void setAdLoadedListener(@Nullable MoPubNativeAdLoadedListener listener) {
        this.mAdLoadedListener = listener;
    }

    public void loadAds(@NonNull String adUnitId) {
        this.mStreamAdPlacer.loadAds(adUnitId);
    }

    public void loadAds(@NonNull String adUnitId, @Nullable RequestParameters requestParameters) {
        this.mStreamAdPlacer.loadAds(adUnitId, requestParameters);
    }

    public boolean isAd(int position) {
        return this.mStreamAdPlacer.isAd(position);
    }

    public void clearAds() {
        this.mStreamAdPlacer.clearAds();
    }

    public void destroy() {
        this.mStreamAdPlacer.destroy();
        this.mVisibilityTracker.destroy();
    }

    public boolean areAllItemsEnabled() {
        return this.mOriginalAdapter instanceof ListAdapter && ((ListAdapter)this.mOriginalAdapter).areAllItemsEnabled();
    }

    public boolean isEnabled(int position) {
        return this.isAd(position) || this.mOriginalAdapter instanceof ListAdapter && ((ListAdapter)this.mOriginalAdapter).isEnabled(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public int getCount() {
        return this.mStreamAdPlacer.getAdjustedCount(this.mOriginalAdapter.getCount());
    }

    @Nullable
    public Object getItem(int position) {
        Object ad = this.mStreamAdPlacer.getAdData(position);
        if (ad != null) {
            return ad;
        }
        return this.mOriginalAdapter.getItem(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public long getItemId(int position) {
        Object adData = this.mStreamAdPlacer.getAdData(position);
        if (adData != null) {
            return -System.identityHashCode(adData);
        }
        return this.mOriginalAdapter.getItemId(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public boolean hasStableIds() {
        return this.mOriginalAdapter.hasStableIds();
    }

    @Nullable
    public View getView(int position, View view, ViewGroup viewGroup) {
        View adView = this.mStreamAdPlacer.getAdView(position, view, viewGroup);
        View resultView = adView != null ? adView : this.mOriginalAdapter.getView(this.mStreamAdPlacer.getOriginalPosition(position), view, viewGroup);
        this.mViewPositionMap.put(resultView, position);
        this.mVisibilityTracker.addView(resultView, 0);
        return resultView;
    }

    public int getItemViewType(int position) {
        int viewType = this.mStreamAdPlacer.getAdViewType(position);
        if (viewType != 0) {
            return viewType + this.mOriginalAdapter.getViewTypeCount() - 1;
        }
        return this.mOriginalAdapter.getItemViewType(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public int getViewTypeCount() {
        return this.mOriginalAdapter.getViewTypeCount() + this.mStreamAdPlacer.getAdViewTypeCount();
    }

    public boolean isEmpty() {
        return this.mOriginalAdapter.isEmpty() && this.mStreamAdPlacer.getAdjustedCount(0) == 0;
    }

    private void handleVisibilityChange(@NonNull List<View> visibleViews) {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (View view : visibleViews) {
            Integer pos = this.mViewPositionMap.get(view);
            if (pos == null) continue;
            min = Math.min(pos, min);
            max = Math.max(pos, max);
        }
        this.mStreamAdPlacer.placeAdsInRange(min, max + 1);
    }

    public int getOriginalPosition(int position) {
        return this.mStreamAdPlacer.getOriginalPosition(position);
    }

    public int getAdjustedPosition(int originalPosition) {
        return this.mStreamAdPlacer.getAdjustedPosition(originalPosition);
    }

    public void insertItem(int originalPosition) {
        this.mStreamAdPlacer.insertItem(originalPosition);
    }

    public void removeItem(int originalPosition) {
        this.mStreamAdPlacer.removeItem(originalPosition);
    }

    public void setOnClickListener(@NonNull ListView listView, final @Nullable AdapterView.OnItemClickListener listener) {
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.setOnClickListener with a null ListView")) {
            return;
        }
        if (listener == null) {
            listView.setOnItemClickListener(null);
            return;
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
                if (!MoPubAdAdapter.this.mStreamAdPlacer.isAd(position)) {
                    listener.onItemClick(adapterView, view, MoPubAdAdapter.this.mStreamAdPlacer.getOriginalPosition(position), id);
                }
            }
        });
    }

    public void setOnItemLongClickListener(@NonNull ListView listView, final @Nullable AdapterView.OnItemLongClickListener listener) {
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.setOnItemLongClickListener with a null ListView")) {
            return;
        }
        if (listener == null) {
            listView.setOnItemLongClickListener(null);
            return;
        }
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int position, long id) {
                return MoPubAdAdapter.this.isAd(position) || listener.onItemLongClick(adapterView, view, MoPubAdAdapter.this.mStreamAdPlacer.getOriginalPosition(position), id);
            }
        });
    }

    public void setOnItemSelectedListener(@NonNull ListView listView, final @Nullable AdapterView.OnItemSelectedListener listener) {
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.setOnItemSelectedListener with a null ListView")) {
            return;
        }
        if (listener == null) {
            listView.setOnItemSelectedListener(null);
            return;
        }
        listView.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id) {
                if (!MoPubAdAdapter.this.isAd(position)) {
                    listener.onItemSelected(adapterView, view, MoPubAdAdapter.this.mStreamAdPlacer.getOriginalPosition(position), id);
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
                listener.onNothingSelected(adapterView);
            }
        });
    }

    public void setSelection(@NonNull ListView listView, int originalPosition) {
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.setSelection with a null ListView")) {
            return;
        }
        listView.setSelection(this.mStreamAdPlacer.getAdjustedPosition(originalPosition));
    }

    public void smoothScrollToPosition(@NonNull ListView listView, int originalPosition) {
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.smoothScrollToPosition with a null ListView")) {
            return;
        }
        listView.smoothScrollToPosition(this.mStreamAdPlacer.getAdjustedPosition(originalPosition));
    }

    public void refreshAds(@NonNull ListView listView, @NonNull String adUnitId) {
        this.refreshAds(listView, adUnitId, null);
    }

    public void refreshAds(@NonNull ListView listView, @NonNull String adUnitId, @Nullable RequestParameters requestParameters) {
        int lastPosition;
        int startRange;
        if (!Preconditions.NoThrow.checkNotNull(listView, "You called MoPubAdAdapter.refreshAds with a null ListView")) {
            return;
        }
        View firstView = listView.getChildAt(0);
        int offsetY = firstView == null ? 0 : firstView.getTop();
        int firstPosition = listView.getFirstVisiblePosition();
        for (startRange = Math.max(firstPosition - 1, 0); this.mStreamAdPlacer.isAd(startRange) && startRange > 0; --startRange) {
        }
        for (lastPosition = listView.getLastVisiblePosition(); this.mStreamAdPlacer.isAd(lastPosition) && lastPosition < this.getCount() - 1; ++lastPosition) {
        }
        int originalStartRange = this.mStreamAdPlacer.getOriginalPosition(startRange);
        int originalEndRange = this.mStreamAdPlacer.getOriginalCount(lastPosition + 1);
        int originalCount = this.mStreamAdPlacer.getOriginalCount(this.getCount());
        this.mStreamAdPlacer.removeAdsInRange(originalEndRange, originalCount);
        int numAdsRemoved = this.mStreamAdPlacer.removeAdsInRange(0, originalStartRange);
        if (numAdsRemoved > 0) {
            listView.setSelectionFromTop(firstPosition - numAdsRemoved, offsetY);
        }
        this.loadAds(adUnitId, requestParameters);
    }
}

