/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.NativeResponse;
import com.mopub.nativeads.TimestampWrapper;
import com.mopub.nativeads.VisibilityTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class ImpressionTracker {
    private static final int PERIOD = 250;
    @NonNull
    private final VisibilityTracker mVisibilityTracker;
    @NonNull
    private final Map<View, NativeResponse> mTrackedViews;
    @NonNull
    private final Map<View, TimestampWrapper<NativeResponse>> mPollingViews;
    @NonNull
    private final Handler mPollHandler;
    @NonNull
    private final PollingRunnable mPollingRunnable;
    @NonNull
    private final VisibilityTracker.VisibilityChecker mVisibilityChecker;
    @Nullable
    private VisibilityTracker.VisibilityTrackerListener mVisibilityTrackerListener;

    ImpressionTracker(@NonNull Context context) {
        this(new WeakHashMap<View, NativeResponse>(), new WeakHashMap<View, TimestampWrapper<NativeResponse>>(), new VisibilityTracker.VisibilityChecker(), new VisibilityTracker(context), new Handler());
    }

    @VisibleForTesting
    ImpressionTracker(@NonNull Map<View, NativeResponse> trackedViews, @NonNull Map<View, TimestampWrapper<NativeResponse>> pollingViews, @NonNull VisibilityTracker.VisibilityChecker visibilityChecker, @NonNull VisibilityTracker visibilityTracker, @NonNull Handler handler) {
        this.mTrackedViews = trackedViews;
        this.mPollingViews = pollingViews;
        this.mVisibilityChecker = visibilityChecker;
        this.mVisibilityTracker = visibilityTracker;
        this.mVisibilityTrackerListener = new VisibilityTracker.VisibilityTrackerListener(){

            @Override
            public void onVisibilityChanged(@NonNull List<View> visibleViews, @NonNull List<View> invisibleViews) {
                for (View view : visibleViews) {
                    NativeResponse nativeResponse = (NativeResponse)ImpressionTracker.this.mTrackedViews.get(view);
                    if (nativeResponse == null) {
                        ImpressionTracker.this.removeView(view);
                        continue;
                    }
                    TimestampWrapper polling = (TimestampWrapper)ImpressionTracker.this.mPollingViews.get(view);
                    if (polling != null && nativeResponse.equals(polling.mInstance)) continue;
                    ImpressionTracker.this.mPollingViews.put(view, new TimestampWrapper<NativeResponse>(nativeResponse));
                }
                for (View view : invisibleViews) {
                    ImpressionTracker.this.mPollingViews.remove(view);
                }
                ImpressionTracker.this.scheduleNextPoll();
            }
        };
        this.mVisibilityTracker.setVisibilityTrackerListener(this.mVisibilityTrackerListener);
        this.mPollHandler = handler;
        this.mPollingRunnable = new PollingRunnable();
    }

    void addView(View view, @NonNull NativeResponse nativeResponse) {
        if (this.mTrackedViews.get(view) == nativeResponse) {
            return;
        }
        this.removeView(view);
        if (nativeResponse.getRecordedImpression() || nativeResponse.isDestroyed()) {
            return;
        }
        this.mTrackedViews.put(view, nativeResponse);
        this.mVisibilityTracker.addView(view, nativeResponse.getImpressionMinPercentageViewed());
    }

    void removeView(View view) {
        this.mTrackedViews.remove(view);
        this.removePollingView(view);
        this.mVisibilityTracker.removeView(view);
    }

    void clear() {
        this.mTrackedViews.clear();
        this.mPollingViews.clear();
        this.mVisibilityTracker.clear();
        this.mPollHandler.removeMessages(0);
    }

    void destroy() {
        this.clear();
        this.mVisibilityTracker.destroy();
        this.mVisibilityTrackerListener = null;
    }

    @VisibleForTesting
    void scheduleNextPoll() {
        if (this.mPollHandler.hasMessages(0)) {
            return;
        }
        this.mPollHandler.postDelayed((Runnable)this.mPollingRunnable, 250L);
    }

    private void removePollingView(View view) {
        this.mPollingViews.remove(view);
    }

    @Deprecated
    @Nullable
    @VisibleForTesting
    VisibilityTracker.VisibilityTrackerListener getVisibilityTrackerListener() {
        return this.mVisibilityTrackerListener;
    }

    @VisibleForTesting
    class PollingRunnable
    implements Runnable {
        @NonNull
        private final ArrayList<View> mRemovedViews = new ArrayList();

        PollingRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : ImpressionTracker.this.mPollingViews.entrySet()) {
                View view = (View)entry.getKey();
                TimestampWrapper timestampWrapper = (TimestampWrapper)entry.getValue();
                if (!ImpressionTracker.this.mVisibilityChecker.hasRequiredTimeElapsed(timestampWrapper.mCreatedTimestamp, ((NativeResponse)timestampWrapper.mInstance).getImpressionMinTimeViewed())) continue;
                ((NativeResponse)timestampWrapper.mInstance).recordImpression(view);
                this.mRemovedViews.add(view);
            }
            for (View view : this.mRemovedViews) {
                ImpressionTracker.this.removeView(view);
            }
            this.mRemovedViews.clear();
            if (!ImpressionTracker.this.mPollingViews.isEmpty()) {
                ImpressionTracker.this.scheduleNextPoll();
            }
        }
    }
}

