/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.factories.CustomEventNativeFactory;
import com.mopub.network.AdResponse;
import java.util.Map;

final class CustomEventNativeAdapter {
    private CustomEventNativeAdapter() {
    }

    public static void loadNativeAd(@NonNull Context context, @NonNull Map<String, Object> localExtras, @NonNull AdResponse adResponse, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
        CustomEventNative customEventNative;
        String customEventNativeClassName = adResponse.getCustomEventClassName();
        try {
            customEventNative = CustomEventNativeFactory.create(customEventNativeClassName);
        }
        catch (Exception e) {
            MoPubLog.w("Failed to load Custom Event Native class: " + customEventNativeClassName);
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
            return;
        }
        if (adResponse.hasJson()) {
            localExtras.put("com_mopub_native_json", adResponse.getJsonBody());
        }
        try {
            customEventNative.loadNativeAd(context, customEventNativeListener, localExtras, adResponse.getServerExtras());
        }
        catch (Exception e) {
            MoPubLog.w("Loading custom event native threw an error.", e);
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
        }
    }
}

