/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeAdInterface;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.ImageLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

abstract class BaseForwardingNativeAd
implements NativeAdInterface {
    private static final int IMPRESSION_MIN_PERCENTAGE_VIEWED = 50;
    @Nullable
    private NativeEventListener mNativeEventListener;
    static final double MIN_STAR_RATING = 0.0;
    static final double MAX_STAR_RATING = 5.0;
    @Nullable
    private String mMainImageUrl;
    @Nullable
    private String mIconImageUrl;
    @Nullable
    private String mClickDestinationUrl;
    @Nullable
    private String mCallToAction;
    @Nullable
    private String mTitle;
    @Nullable
    private String mText;
    @Nullable
    private Double mStarRating;
    @NonNull
    private final Set<String> mImpressionTrackers = new HashSet<String>();
    private int mImpressionMinTimeViewed = 1000;
    @NonNull
    private final Map<String, Object> mExtras = new HashMap<String, Object>();
    private boolean mIsOverridingClickTracker;
    private boolean mIsOverridingImpressionTracker;

    BaseForwardingNativeAd() {
    }

    @Override
    @Nullable
    public final String getMainImageUrl() {
        return this.mMainImageUrl;
    }

    @Override
    @Nullable
    public final String getIconImageUrl() {
        return this.mIconImageUrl;
    }

    @Override
    @NonNull
    public final Set<String> getImpressionTrackers() {
        return new HashSet<String>(this.mImpressionTrackers);
    }

    @Override
    @Nullable
    public final String getClickDestinationUrl() {
        return this.mClickDestinationUrl;
    }

    @Override
    @Nullable
    public final String getCallToAction() {
        return this.mCallToAction;
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.mTitle;
    }

    @Override
    @Nullable
    public final String getText() {
        return this.mText;
    }

    @Override
    @Nullable
    public final Double getStarRating() {
        return this.mStarRating;
    }

    @Override
    public final int getImpressionMinPercentageViewed() {
        return 50;
    }

    @Override
    public final int getImpressionMinTimeViewed() {
        return this.mImpressionMinTimeViewed;
    }

    @Override
    @Nullable
    public final Object getExtra(@NonNull String key) {
        if (!Preconditions.NoThrow.checkNotNull(key, "getExtra key is not allowed to be null")) {
            return null;
        }
        return this.mExtras.get(key);
    }

    @Override
    @NonNull
    public final Map<String, Object> getExtras() {
        return new HashMap<String, Object>(this.mExtras);
    }

    @Override
    public final boolean isOverridingImpressionTracker() {
        return this.mIsOverridingImpressionTracker;
    }

    @Override
    public final boolean isOverridingClickTracker() {
        return this.mIsOverridingClickTracker;
    }

    @Override
    public final void setNativeEventListener(@Nullable NativeEventListener nativeEventListener) {
        this.mNativeEventListener = nativeEventListener;
    }

    final void setMainImageUrl(@Nullable String mainImageUrl) {
        this.mMainImageUrl = mainImageUrl;
    }

    final void setIconImageUrl(@Nullable String iconImageUrl) {
        this.mIconImageUrl = iconImageUrl;
    }

    final void setClickDestinationUrl(@Nullable String clickDestinationUrl) {
        this.mClickDestinationUrl = clickDestinationUrl;
    }

    final void setCallToAction(@Nullable String callToAction) {
        this.mCallToAction = callToAction;
    }

    final void setTitle(@Nullable String title) {
        this.mTitle = title;
    }

    final void setText(@Nullable String text) {
        this.mText = text;
    }

    final void setStarRating(@Nullable Double starRating) {
        if (starRating == null) {
            this.mStarRating = null;
        } else if (starRating >= 0.0 && starRating <= 5.0) {
            this.mStarRating = starRating;
        } else {
            MoPubLog.d("Ignoring attempt to set invalid star rating (" + starRating + "). Must be " + "between " + 0.0 + " and " + 5.0 + ".");
        }
    }

    final void addExtra(@NonNull String key, @Nullable Object value) {
        if (!Preconditions.NoThrow.checkNotNull(key, "addExtra key is not allowed to be null")) {
            return;
        }
        this.mExtras.put(key, value);
    }

    final void addImpressionTracker(@NonNull String url) {
        if (!Preconditions.NoThrow.checkNotNull(url, "impressionTracker url is not allowed to be null")) {
            return;
        }
        this.mImpressionTrackers.add(url);
    }

    final void setImpressionMinTimeViewed(int impressionMinTimeViewed) {
        if (impressionMinTimeViewed >= 0) {
            this.mImpressionMinTimeViewed = impressionMinTimeViewed;
        }
    }

    final void setOverridingImpressionTracker(boolean isOverridingImpressionTracker) {
        this.mIsOverridingImpressionTracker = isOverridingImpressionTracker;
    }

    final void setOverridingClickTracker(boolean isOverridingClickTracker) {
        this.mIsOverridingClickTracker = isOverridingClickTracker;
    }

    @Override
    public void prepare(@Nullable View view) {
    }

    @Override
    public void recordImpression() {
    }

    @Override
    public void handleClick(@Nullable View view) {
    }

    @Override
    public void clear(@Nullable View view) {
    }

    @Override
    public void destroy() {
    }

    protected final void notifyAdImpressed() {
        if (this.mNativeEventListener != null) {
            this.mNativeEventListener.onAdImpressed();
        }
    }

    protected final void notifyAdClicked() {
        if (this.mNativeEventListener != null) {
            this.mNativeEventListener.onAdClicked();
        }
    }

    static void preCacheImages(@NonNull Context context, @NonNull List<String> imageUrls, final @NonNull CustomEventNative.ImageListener imageListener) {
        ImageLoader imageLoader = Networking.getImageLoader(context);
        final AtomicInteger imageCounter = new AtomicInteger(imageUrls.size());
        final AtomicBoolean anyFailures = new AtomicBoolean(false);
        ImageLoader.ImageListener volleyImageListener = new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean isImmediate) {
                int count;
                if (imageContainer.getBitmap() != null && (count = imageCounter.decrementAndGet()) == 0 && !anyFailures.get()) {
                    imageListener.onImagesCached();
                }
            }

            public void onErrorResponse(VolleyError volleyError) {
                MoPubLog.d("Failed to download a native ads image:", (Throwable)volleyError);
                boolean anyPreviousErrors = anyFailures.getAndSet(true);
                imageCounter.decrementAndGet();
                if (!anyPreviousErrors) {
                    imageListener.onImagesFailedToCache(NativeErrorCode.IMAGE_DOWNLOAD_FAILURE);
                }
            }
        };
        for (String url : imageUrls) {
            if (TextUtils.isEmpty((CharSequence)url)) {
                anyFailures.set(true);
                imageListener.onImagesFailedToCache(NativeErrorCode.IMAGE_DOWNLOAD_FAILURE);
                return;
            }
            imageLoader.get(url, volleyImageListener);
        }
    }

    static interface NativeEventListener {
        public void onAdImpressed();

        public void onAdClicked();
    }
}

