/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.resource;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.BaseWidgetDrawable;
import com.mopub.mobileads.resource.DrawableConstants;

public class ProgressBarDrawable
extends BaseWidgetDrawable {
    @NonNull
    private final Paint mBackgroundPaint = new Paint();
    @NonNull
    private final Paint mProgressPaint;
    private int mDuration;
    private int mSkipOffset;
    private int mCurrentProgress;
    private int mLastProgress;
    private float mSkipRatio;
    private final int mNuggetWidth;

    public ProgressBarDrawable(@NonNull Context context) {
        this.mBackgroundPaint.setColor(-1);
        this.mBackgroundPaint.setAlpha(128);
        this.mBackgroundPaint.setStyle(DrawableConstants.ProgressBar.BACKGROUND_STYLE);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setColor(DrawableConstants.ProgressBar.PROGRESS_COLOR);
        this.mProgressPaint.setAlpha(255);
        this.mProgressPaint.setStyle(DrawableConstants.ProgressBar.PROGRESS_STYLE);
        this.mProgressPaint.setAntiAlias(true);
        this.mNuggetWidth = Dips.dipsToIntPixels(4.0f, context);
    }

    public void draw(Canvas canvas) {
        canvas.drawRect(this.getBounds(), this.mBackgroundPaint);
        float progressRatio = (float)this.mCurrentProgress / (float)this.mDuration;
        canvas.drawRect((float)this.getBounds().left, (float)this.getBounds().top, (float)this.getBounds().right * progressRatio, (float)this.getBounds().bottom, this.mProgressPaint);
        if (this.mSkipOffset > 0 && this.mSkipOffset < this.mDuration) {
            float nuggetPosition = (float)this.getBounds().right * this.mSkipRatio;
            canvas.drawRect(nuggetPosition, (float)this.getBounds().top, nuggetPosition + (float)this.mNuggetWidth, (float)this.getBounds().bottom, this.mProgressPaint);
        }
    }

    public void setDurationAndSkipOffset(int duration, int skipOffset) {
        this.mDuration = duration;
        this.mSkipOffset = skipOffset;
        this.mSkipRatio = (float)this.mSkipOffset / (float)this.mDuration;
    }

    public void setProgress(int currentProgress) {
        if (currentProgress >= this.mLastProgress) {
            this.mCurrentProgress = currentProgress;
            this.mLastProgress = currentProgress;
        } else if (currentProgress != 0) {
            MoPubLog.d(String.format("Progress not monotonically increasing: last = %d, current = %d", this.mLastProgress, currentProgress));
            this.forceCompletion();
        }
        this.invalidateSelf();
    }

    @VisibleForTesting
    public void forceCompletion() {
        this.mCurrentProgress = this.mDuration;
    }

    @Deprecated
    @VisibleForTesting
    public float getSkipRatio() {
        return this.mSkipRatio;
    }

    @Deprecated
    @VisibleForTesting
    public int getCurrentProgress() {
        return this.mCurrentProgress;
    }
}

