/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdAlertGestureListener;

public class ViewGestureDetector
extends GestureDetector {
    private final View mView;
    private AdAlertGestureListener mAdAlertGestureListener;
    private UserClickListener mUserClickListener;

    public ViewGestureDetector(@NonNull Context context, @NonNull View view, @Nullable AdReport adReport) {
        this(context, view, new AdAlertGestureListener(view, adReport));
    }

    private ViewGestureDetector(Context context, View view, AdAlertGestureListener adAlertGestureListener) {
        super(context, (GestureDetector.OnGestureListener)adAlertGestureListener);
        this.mAdAlertGestureListener = adAlertGestureListener;
        this.mView = view;
        this.setIsLongpressEnabled(false);
    }

    public void sendTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.mUserClickListener != null) {
                    this.mUserClickListener.onUserClick();
                } else {
                    MoPubLog.d("View's onUserClick() is not registered.");
                }
                this.mAdAlertGestureListener.finishGestureDetection();
                break;
            }
            case 0: {
                this.onTouchEvent(motionEvent);
                break;
            }
            case 2: {
                if (this.isMotionEventInView(motionEvent, this.mView)) {
                    this.onTouchEvent(motionEvent);
                    break;
                }
                this.resetAdFlaggingGesture();
                break;
            }
        }
    }

    public void setUserClickListener(UserClickListener listener) {
        this.mUserClickListener = listener;
    }

    void resetAdFlaggingGesture() {
        this.mAdAlertGestureListener.reset();
    }

    private boolean isMotionEventInView(MotionEvent motionEvent, View view) {
        if (motionEvent == null || view == null) {
            return false;
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        return x >= 0.0f && x <= (float)view.getWidth() && y >= 0.0f && y <= (float)view.getHeight();
    }

    @Deprecated
    void setAdAlertGestureListener(AdAlertGestureListener adAlertGestureListener) {
        this.mAdAlertGestureListener = adAlertGestureListener;
    }

    public static interface UserClickListener {
        public void onUserClick();

        public void onResetUserClick();

        public boolean wasClicked();
    }
}

