/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import android.widget.VideoView;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.Streams;
import com.mopub.mobileads.VastVideoBlurLastVideoFrameTask;
import java.io.File;
import java.io.FileInputStream;

public class VastVideoView
extends VideoView {
    private static final int MAX_VIDEO_RETRIES = 1;
    private static final int VIDEO_VIEW_FILE_PERMISSION_ERROR = Integer.MIN_VALUE;
    @Nullable
    private VastVideoBlurLastVideoFrameTask mBlurLastVideoFrameTask;
    @Nullable
    private MediaMetadataRetriever mMediaMetadataRetriever;
    private int mVideoRetries;

    public VastVideoView(@NonNull Context context) {
        super(context);
        Preconditions.checkNotNull(context, "context cannot be null");
        this.mMediaMetadataRetriever = this.createMediaMetadataRetriever();
    }

    public void prepareBlurredLastVideoFrame(@NonNull ImageView blurredLastVideoFrameImageView, @NonNull String diskMediaFileUrl) {
        if (this.mMediaMetadataRetriever != null) {
            this.mBlurLastVideoFrameTask = new VastVideoBlurLastVideoFrameTask(this.mMediaMetadataRetriever, blurredLastVideoFrameImageView, this.getDuration());
            try {
                AsyncTasks.safeExecuteOnExecutor(this.mBlurLastVideoFrameTask, diskMediaFileUrl);
            }
            catch (Exception e) {
                MoPubLog.d("Failed to blur last video frame", e);
            }
        }
    }

    public void onDestroy() {
        if (this.mBlurLastVideoFrameTask != null && this.mBlurLastVideoFrameTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mBlurLastVideoFrameTask.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean retryMediaPlayer(MediaPlayer mediaPlayer, int what, int extra, @NonNull String diskMediaFileUrl) {
        if (Build.VERSION.SDK_INT < 16 && what == 1 && extra == Integer.MIN_VALUE && this.mVideoRetries < 1) {
            FileInputStream inputStream = null;
            try {
                mediaPlayer.reset();
                File file = new File(diskMediaFileUrl);
                inputStream = new FileInputStream(file);
                mediaPlayer.setDataSource(inputStream.getFD());
                mediaPlayer.prepareAsync();
                this.start();
                boolean bl = true;
                Streams.closeStream(inputStream);
                ++this.mVideoRetries;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                Streams.closeStream(inputStream);
                ++this.mVideoRetries;
            }
        }
        return false;
    }

    public void onResume() {
        this.mVideoRetries = 0;
    }

    @VisibleForTesting
    @Nullable
    MediaMetadataRetriever createMediaMetadataRetriever() {
        if (Build.VERSION.SDK_INT >= 10) {
            return new MediaMetadataRetriever();
        }
        return null;
    }

    @Deprecated
    @VisibleForTesting
    void setMediaMetadataRetriever(@NonNull MediaMetadataRetriever mediaMetadataRetriever) {
        this.mMediaMetadataRetriever = mediaMetadataRetriever;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    VastVideoBlurLastVideoFrameTask getBlurLastVideoFrameTask() {
        return this.mBlurLastVideoFrameTask;
    }

    @Deprecated
    @VisibleForTesting
    void setBlurLastVideoFrameTask(@NonNull VastVideoBlurLastVideoFrameTask blurLastVideoFrameTask) {
        this.mBlurLastVideoFrameTask = blurLastVideoFrameTask;
    }

    @Deprecated
    @VisibleForTesting
    int getVideoRetries() {
        return this.mVideoRetries;
    }
}

