/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import com.mopub.common.CacheService;
import com.mopub.common.HttpClient;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class VastVideoDownloadTask
extends AsyncTask<String, Void, Boolean> {
    private static final int MAX_VIDEO_SIZE = 0x1900000;
    private final VastVideoDownloadTaskListener mVastVideoDownloadTaskListener;

    public VastVideoDownloadTask(VastVideoDownloadTaskListener listener) {
        this.mVastVideoDownloadTaskListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground(String ... params) {
        if (params == null || params.length == 0 || params[0] == null) {
            return false;
        }
        String videoUrl = params[0];
        try (AndroidHttpClient httpClient = null;){
            httpClient = HttpClient.getHttpClient();
            HttpGet httpget = HttpClient.initializeHttpGet(videoUrl);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            if (response == null || response.getEntity() == null) {
                throw new IOException("Obtained null response from video url: " + videoUrl);
            }
            if (response.getEntity().getContentLength() > 0x1900000L) {
                throw new IOException("Video exceeded max download size");
            }
            BufferedInputStream inputStream = new BufferedInputStream(response.getEntity().getContent());
            boolean diskPutResult = CacheService.putToDiskCache(videoUrl, inputStream);
            ((InputStream)inputStream).close();
            Boolean bl = diskPutResult;
            return bl;
        }
    }

    protected void onCancelled() {
        this.onPostExecute(false);
    }

    protected void onPostExecute(Boolean success) {
        if (this.mVastVideoDownloadTaskListener != null) {
            this.mVastVideoDownloadTaskListener.onComplete(success);
        }
    }

    public static interface VastVideoDownloadTaskListener {
        public void onComplete(boolean var1);
    }
}

