/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastResourceXmlManager;
import com.mopub.mobileads.VastWebView;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

class VastResource
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final List<String> VALID_IMAGE_TYPES = Arrays.asList("image/jpeg", "image/png", "image/bmp", "image/gif");
    private static final List<String> VALID_APPLICATION_TYPES = Arrays.asList("application/x-javascript");
    @NonNull
    private String mResource;
    @NonNull
    private Type mType;
    @NonNull
    private CreativeType mCreativeType;
    private int mWidth;
    private int mHeight;

    @Nullable
    static VastResource fromVastResourceXmlManager(@NonNull VastResourceXmlManager resourceXmlManager, int width, int height) {
        for (Type type : Type.values()) {
            VastResource vastResource = VastResource.fromVastResourceXmlManager(resourceXmlManager, type, width, height);
            if (vastResource == null) continue;
            return vastResource;
        }
        return null;
    }

    @Nullable
    static VastResource fromVastResourceXmlManager(@NonNull VastResourceXmlManager resourceXmlManager, @NonNull Type type, int width, int height) {
        CreativeType creativeType;
        String resource;
        Preconditions.checkNotNull(resourceXmlManager);
        Preconditions.checkNotNull((Object)type);
        String iFrameResource = resourceXmlManager.getIFrameResource();
        String htmlResource = resourceXmlManager.getHTMLResource();
        String staticResource = resourceXmlManager.getStaticResource();
        String staticResourceType = resourceXmlManager.getStaticResourceType();
        if (type == Type.STATIC_RESOURCE && staticResource != null && staticResourceType != null && (VALID_IMAGE_TYPES.contains(staticResourceType) || VALID_APPLICATION_TYPES.contains(staticResourceType))) {
            resource = staticResource;
            creativeType = VALID_IMAGE_TYPES.contains(staticResourceType) ? CreativeType.IMAGE : CreativeType.JAVASCRIPT;
        } else if (type == Type.HTML_RESOURCE && htmlResource != null) {
            resource = htmlResource;
            creativeType = CreativeType.NONE;
        } else if (type == Type.IFRAME_RESOURCE && iFrameResource != null) {
            resource = iFrameResource;
            creativeType = CreativeType.NONE;
        } else {
            return null;
        }
        return new VastResource(resource, type, creativeType, width, height);
    }

    VastResource(@NonNull String resource, @NonNull Type type, @NonNull CreativeType creativeType, int width, int height) {
        Preconditions.checkNotNull(resource);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)creativeType);
        this.mResource = resource;
        this.mType = type;
        this.mCreativeType = creativeType;
        this.mWidth = width;
        this.mHeight = height;
    }

    @NonNull
    public String getResource() {
        return this.mResource;
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @NonNull
    public CreativeType getCreativeType() {
        return this.mCreativeType;
    }

    public void initializeWebView(@NonNull VastWebView webView) {
        Preconditions.checkNotNull((Object)webView);
        if (this.mType == Type.IFRAME_RESOURCE) {
            webView.loadData("<iframe frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" style=\"border: 0px; margin: 0px;\" width=\"" + this.mWidth + "\" height=\"" + this.mHeight + "\" src=\"" + this.mResource + "\"></iframe>");
        } else if (this.mType == Type.HTML_RESOURCE) {
            webView.loadData(this.mResource);
        } else if (this.mType == Type.STATIC_RESOURCE) {
            if (this.mCreativeType == CreativeType.IMAGE) {
                String data = "<html><head></head><body style=\"margin:0;padding:0\"><img src=\"" + this.mResource + "\" width=\"100%\" style=\"max-width:100%;max-height:100%;\" />" + "</body>" + "</html>";
                webView.loadData(data);
            } else if (this.mCreativeType == CreativeType.JAVASCRIPT) {
                String data = "<script src=\"" + this.mResource + "\"></script>";
                webView.loadData(data);
            }
        }
    }

    @Nullable
    public String getCorrectClickThroughUrl(@Nullable String vastClickThroughUrl, @Nullable String webViewClickThroughUrl) {
        switch (this.mType) {
            case STATIC_RESOURCE: {
                if (CreativeType.IMAGE == this.mCreativeType) {
                    return vastClickThroughUrl;
                }
                if (CreativeType.JAVASCRIPT == this.mCreativeType) {
                    return webViewClickThroughUrl;
                }
                return null;
            }
            case HTML_RESOURCE: 
            case IFRAME_RESOURCE: {
                return webViewClickThroughUrl;
            }
        }
        return null;
    }

    static enum CreativeType {
        NONE,
        IMAGE,
        JAVASCRIPT;

    }

    static enum Type {
        STATIC_RESOURCE,
        HTML_RESOURCE,
        IFRAME_RESOURCE;

    }
}

