/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.util.XmlUtils;
import org.w3c.dom.Node;

class VastMediaXmlManager {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DELIVERY = "delivery";
    private static final String VIDEO_TYPE = "type";
    @NonNull
    private final Node mMediaNode;

    VastMediaXmlManager(@NonNull Node mediaNode) {
        Preconditions.checkNotNull(mediaNode, "mediaNode cannot be null");
        this.mMediaNode = mediaNode;
    }

    @Nullable
    String getDelivery() {
        return XmlUtils.getAttributeValue(this.mMediaNode, DELIVERY);
    }

    @Nullable
    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt(this.mMediaNode, WIDTH);
    }

    @Nullable
    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt(this.mMediaNode, HEIGHT);
    }

    @Nullable
    String getType() {
        return XmlUtils.getAttributeValue(this.mMediaNode, VIDEO_TYPE);
    }

    @Nullable
    String getMediaUrl() {
        return XmlUtils.getNodeValue(this.mMediaNode);
    }
}

