/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.mopub.mobileads.CustomEventRewardedVideo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class RewardedVideoData {
    @NonNull
    private final Map<String, CustomEventRewardedVideo> mAdUnitToCustomEventMap = new TreeMap<String, CustomEventRewardedVideo>();
    @NonNull
    private final Map<TwoPartKey, Set<String>> mCustomEventToMoPubIdMap = new HashMap<TwoPartKey, Set<String>>();
    @NonNull
    private final Set<CustomEventRewardedVideo.CustomEventRewardedVideoListener> mAdNetworkListeners = new HashSet<CustomEventRewardedVideo.CustomEventRewardedVideoListener>();

    RewardedVideoData() {
    }

    @Nullable
    CustomEventRewardedVideo getCustomEvent(@NonNull String moPubId) {
        return this.mAdUnitToCustomEventMap.get(moPubId);
    }

    @NonNull
    Set<String> getMoPubIdsForAdNetwork(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @Nullable String adNetworkId) {
        if (adNetworkId == null) {
            HashSet<String> allIds = new HashSet<String>();
            for (Map.Entry<TwoPartKey, Set<String>> entry : this.mCustomEventToMoPubIdMap.entrySet()) {
                Class<? extends CustomEventRewardedVideo> clazz = entry.getKey().customEventClass;
                if (customEventClass != clazz) continue;
                allIds.addAll((Collection<String>)entry.getValue());
            }
            return allIds;
        }
        TwoPartKey key = new TwoPartKey(customEventClass, adNetworkId);
        return this.mCustomEventToMoPubIdMap.containsKey((Object)key) ? this.mCustomEventToMoPubIdMap.get((Object)key) : Collections.emptySet();
    }

    void updateAdUnitCustomEventMapping(@NonNull String moPubId, @NonNull CustomEventRewardedVideo customEvent, @Nullable CustomEventRewardedVideo.CustomEventRewardedVideoListener listener, @NonNull String adNetworkId) {
        this.mAdUnitToCustomEventMap.put(moPubId, customEvent);
        this.mAdNetworkListeners.add(listener);
        this.associateCustomEventWithMoPubId(customEvent.getClass(), adNetworkId, moPubId);
    }

    void associateCustomEventWithMoPubId(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @NonNull String adNetworkId, @NonNull String moPubId) {
        Set<String> moPubIds;
        TwoPartKey newCustomEventMapping = new TwoPartKey(customEventClass, adNetworkId);
        Iterator<Map.Entry<TwoPartKey, Set<String>>> entryIterator = this.mCustomEventToMoPubIdMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<TwoPartKey, Set<String>> entry = entryIterator.next();
            if (entry.getKey().equals((Object)newCustomEventMapping) || !entry.getValue().contains(moPubId)) continue;
            entry.getValue().remove(moPubId);
            if (!entry.getValue().isEmpty()) break;
            entryIterator.remove();
            break;
        }
        if ((moPubIds = this.mCustomEventToMoPubIdMap.get((Object)newCustomEventMapping)) == null) {
            moPubIds = new HashSet<String>();
            this.mCustomEventToMoPubIdMap.put(newCustomEventMapping, moPubIds);
        }
        moPubIds.add(moPubId);
    }

    private static class TwoPartKey
    extends Pair<Class<? extends CustomEventRewardedVideo>, String> {
        @NonNull
        final Class<? extends CustomEventRewardedVideo> customEventClass;
        @NonNull
        final String adNetworkId;

        public TwoPartKey(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @NonNull String adNetworkId) {
            super(customEventClass, (Object)adNetworkId);
            this.customEventClass = customEventClass;
            this.adNetworkId = adNetworkId;
        }
    }
}

