/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Intents;
import com.mopub.mobileads.BaseVideoPlayerActivity;
import com.mopub.mobileads.BaseVideoViewController;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.VastVideoViewController;
import com.mopub.mraid.MraidVideoViewController;

public class MraidVideoPlayerActivity
extends BaseVideoPlayerActivity
implements BaseVideoViewController.BaseVideoViewControllerListener {
    @Nullable
    private BaseVideoViewController mBaseVideoController;
    private long mBroadcastIdentifier;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        this.mBroadcastIdentifier = MraidVideoPlayerActivity.getBroadcastIdentifierFromIntent(this.getIntent());
        try {
            this.mBaseVideoController = this.createVideoViewController(savedInstanceState);
        }
        catch (IllegalStateException e) {
            EventForwardingBroadcastReceiver.broadcastAction((Context)this, this.mBroadcastIdentifier, "com.mopub.action.interstitial.fail");
            this.finish();
            return;
        }
        this.mBaseVideoController.onCreate();
    }

    protected void onPause() {
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onPause();
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onResume();
        }
    }

    protected void onDestroy() {
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onDestroy();
        }
        super.onDestroy();
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onSaveInstanceState(outState);
        }
    }

    public void onConfigurationChanged(@Nullable Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onConfigurationChanged(newConfig);
        }
    }

    public void onBackPressed() {
        if (this.mBaseVideoController != null && this.mBaseVideoController.backButtonEnabled()) {
            super.onBackPressed();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mBaseVideoController != null) {
            this.mBaseVideoController.onActivityResult(requestCode, resultCode, data);
        }
    }

    private BaseVideoViewController createVideoViewController(Bundle savedInstanceState) throws IllegalStateException {
        String clazz = this.getIntent().getStringExtra("video_view_class_name");
        if ("vast".equals(clazz)) {
            return new VastVideoViewController(this, this.getIntent().getExtras(), savedInstanceState, this.mBroadcastIdentifier, this);
        }
        if ("mraid".equals(clazz)) {
            return new MraidVideoViewController((Context)this, this.getIntent().getExtras(), savedInstanceState, this);
        }
        throw new IllegalStateException("Unsupported video type: " + clazz);
    }

    @Override
    public void onSetContentView(View view) {
        this.setContentView(view);
    }

    @Override
    public void onSetRequestedOrientation(int requestedOrientation) {
        this.setRequestedOrientation(requestedOrientation);
    }

    @Override
    public void onFinish() {
        this.finish();
    }

    @Override
    public void onStartActivityForResult(Class<? extends Activity> clazz, int requestCode, Bundle extras) {
        if (clazz == null) {
            return;
        }
        Intent intent = Intents.getStartActivityIntent((Context)this, clazz, extras);
        try {
            this.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.d("Activity " + clazz.getName() + " not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    protected static long getBroadcastIdentifierFromIntent(Intent intent) {
        return intent.getLongExtra("broadcastIdentifier", -1L);
    }

    @Deprecated
    BaseVideoViewController getBaseVideoViewController() {
        return this.mBaseVideoController;
    }

    @Deprecated
    void setBaseVideoViewController(BaseVideoViewController baseVideoViewController) {
        this.mBaseVideoController = baseVideoViewController;
    }
}

