/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseInterstitialActivity;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.MraidWebViewDebugListener;
import com.mopub.mraid.PlacementType;
import java.io.Serializable;

public class MraidActivity
extends BaseInterstitialActivity {
    @Nullable
    private MraidController mMraidController;
    @Nullable
    private MraidWebViewDebugListener mDebugListener;

    public static void preRenderHtml(@NonNull Context context, final @NonNull CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, @NonNull String htmlData) {
        BaseWebView dummyWebView = new BaseWebView(context);
        dummyWebView.enablePlugins(false);
        dummyWebView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                customEventInterstitialListener.onInterstitialLoaded();
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return true;
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                customEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
            }
        });
        dummyWebView.loadDataWithBaseURL("http://ads.mopub.com/", htmlData, "text/html", "UTF-8", null);
    }

    public static void start(@NonNull Context context, @Nullable AdReport adreport, @NonNull String htmlData, long broadcastIdentifier) {
        Intent intent = MraidActivity.createIntent(context, adreport, htmlData, broadcastIdentifier);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Log.d((String)"MraidInterstitial", (String)"MraidActivity.class not found. Did you declare MraidActivity in your manifest?");
        }
    }

    @VisibleForTesting
    protected static Intent createIntent(@NonNull Context context, @Nullable AdReport adReport, @NonNull String htmlData, long broadcastIdentifier) {
        Intent intent = new Intent(context, MraidActivity.class);
        intent.putExtra("Html-Response-Body", htmlData);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        intent.putExtra("mopub-intent-ad-report", (Serializable)adReport);
        intent.addFlags(0x10000000);
        return intent;
    }

    @Override
    public View getAdView() {
        String htmlData = this.getIntent().getStringExtra("Html-Response-Body");
        if (htmlData == null) {
            MoPubLog.w("MraidActivity received a null HTML body. Finishing the activity.");
            this.finish();
            return new View((Context)this);
        }
        this.mMraidController = new MraidController((Context)this, this.mAdReport, PlacementType.INTERSTITIAL);
        this.mMraidController.setDebugListener(this.mDebugListener);
        this.mMraidController.setMraidListener(new MraidController.MraidListener(){

            @Override
            public void onLoaded(View view) {
                MraidActivity.this.mMraidController.loadJavascript(BaseInterstitialActivity.JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getJavascript());
            }

            @Override
            public void onFailedToLoad() {
                MoPubLog.d("MraidActivity failed to load. Finishing the activity");
                EventForwardingBroadcastReceiver.broadcastAction((Context)MraidActivity.this, MraidActivity.this.getBroadcastIdentifier(), "com.mopub.action.interstitial.fail");
                MraidActivity.this.finish();
            }

            @Override
            public void onClose() {
                MraidActivity.this.mMraidController.loadJavascript(BaseInterstitialActivity.JavaScriptWebViewCallbacks.WEB_VIEW_DID_CLOSE.getJavascript());
                MraidActivity.this.finish();
            }

            @Override
            public void onExpand() {
            }

            @Override
            public void onOpen() {
                EventForwardingBroadcastReceiver.broadcastAction((Context)MraidActivity.this, MraidActivity.this.getBroadcastIdentifier(), "com.mopub.action.interstitial.click");
            }
        });
        this.mMraidController.setUseCustomCloseListener(new MraidController.UseCustomCloseListener(){

            @Override
            public void useCustomCloseChanged(boolean useCustomClose) {
                if (useCustomClose) {
                    MraidActivity.this.hideInterstitialCloseButton();
                } else {
                    MraidActivity.this.showInterstitialCloseButton();
                }
            }
        });
        this.mMraidController.loadContent(htmlData);
        return this.mMraidController.getAdContainer();
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, this.getBroadcastIdentifier(), "com.mopub.action.interstitial.show");
        if (Build.VERSION.SDK_INT >= 14) {
            this.getWindow().setFlags(0x1000000, 0x1000000);
        }
    }

    protected void onPause() {
        if (this.mMraidController != null) {
            this.mMraidController.pause(this.isFinishing());
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (this.mMraidController != null) {
            this.mMraidController.resume();
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mMraidController != null) {
            this.mMraidController.destroy();
        }
        EventForwardingBroadcastReceiver.broadcastAction((Context)this, this.getBroadcastIdentifier(), "com.mopub.action.interstitial.dismiss");
        super.onDestroy();
    }

    @VisibleForTesting
    public void setDebugListener(@Nullable MraidWebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
        if (this.mMraidController != null) {
            this.mMraidController.setDebugListener(debugListener);
        }
    }
}

