/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;

public class EventForwardingBroadcastReceiver
extends BroadcastReceiver {
    private final CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private final long mBroadcastIdentifier;
    private Context mContext;
    public static final String ACTION_INTERSTITIAL_FAIL = "com.mopub.action.interstitial.fail";
    public static final String ACTION_INTERSTITIAL_SHOW = "com.mopub.action.interstitial.show";
    public static final String ACTION_INTERSTITIAL_DISMISS = "com.mopub.action.interstitial.dismiss";
    public static final String ACTION_INTERSTITIAL_CLICK = "com.mopub.action.interstitial.click";
    private static IntentFilter sIntentFilter;

    public EventForwardingBroadcastReceiver(CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, long broadcastIdentifier) {
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        this.mBroadcastIdentifier = broadcastIdentifier;
        sIntentFilter = EventForwardingBroadcastReceiver.getHtmlInterstitialIntentFilter();
    }

    static void broadcastAction(Context context, long broadcastIdentifier, String action) {
        Intent intent = new Intent(action);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static IntentFilter getHtmlInterstitialIntentFilter() {
        if (sIntentFilter == null) {
            sIntentFilter = new IntentFilter();
            sIntentFilter.addAction(ACTION_INTERSTITIAL_FAIL);
            sIntentFilter.addAction(ACTION_INTERSTITIAL_SHOW);
            sIntentFilter.addAction(ACTION_INTERSTITIAL_DISMISS);
            sIntentFilter.addAction(ACTION_INTERSTITIAL_CLICK);
        }
        return sIntentFilter;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mCustomEventInterstitialListener == null) {
            return;
        }
        long receivedIdentifier = intent.getLongExtra("broadcastIdentifier", -1L);
        if (this.mBroadcastIdentifier != receivedIdentifier) {
            return;
        }
        String action = intent.getAction();
        if (ACTION_INTERSTITIAL_FAIL.equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
        } else if (ACTION_INTERSTITIAL_SHOW.equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialShown();
        } else if (ACTION_INTERSTITIAL_DISMISS.equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialDismissed();
            this.unregister();
        } else if (ACTION_INTERSTITIAL_CLICK.equals(action)) {
            this.mCustomEventInterstitialListener.onInterstitialClicked();
        }
    }

    public void register(Context context) {
        this.mContext = context;
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver((BroadcastReceiver)this, sIntentFilter);
    }

    public void unregister() {
        if (this.mContext != null) {
            LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver((BroadcastReceiver)this);
            this.mContext = null;
        }
    }
}

