/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.HtmlBannerWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.CustomEventBannerFactory;
import java.util.Map;
import java.util.TreeMap;

public class CustomEventBannerAdapter
implements CustomEventBanner.CustomEventBannerListener {
    public static final int DEFAULT_BANNER_TIMEOUT_DELAY = 10000;
    private boolean mInvalidated;
    private MoPubView mMoPubView;
    private Context mContext;
    private CustomEventBanner mCustomEventBanner;
    private Map<String, Object> mLocalExtras;
    private Map<String, String> mServerExtras;
    private final Handler mHandler;
    private final Runnable mTimeout;
    private boolean mStoredAutorefresh;

    public CustomEventBannerAdapter(@NonNull MoPubView moPubView, @NonNull String className, @NonNull Map<String, String> serverExtras, long broadcastIdentifier, @Nullable AdReport adReport) {
        Preconditions.checkNotNull(serverExtras);
        this.mHandler = new Handler();
        this.mMoPubView = moPubView;
        this.mContext = moPubView.getContext();
        this.mTimeout = new Runnable(){

            @Override
            public void run() {
                MoPubLog.d("Third-party network timed out.");
                CustomEventBannerAdapter.this.onBannerFailed(MoPubErrorCode.NETWORK_TIMEOUT);
                CustomEventBannerAdapter.this.invalidate();
            }
        };
        MoPubLog.d("Attempting to invoke custom event: " + className);
        try {
            this.mCustomEventBanner = CustomEventBannerFactory.create(className);
        }
        catch (Exception exception) {
            MoPubLog.d("Couldn't locate or instantiate custom event: " + className + ".");
            this.mMoPubView.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
            return;
        }
        this.mServerExtras = new TreeMap<String, String>(serverExtras);
        this.mLocalExtras = this.mMoPubView.getLocalExtras();
        if (this.mMoPubView.getLocation() != null) {
            this.mLocalExtras.put("location", this.mMoPubView.getLocation());
        }
        this.mLocalExtras.put("broadcastIdentifier", broadcastIdentifier);
        this.mLocalExtras.put("mopub-intent-ad-report", adReport);
        this.mLocalExtras.put("com_mopub_ad_width", this.mMoPubView.getAdWidth());
        this.mLocalExtras.put("com_mopub_ad_height", this.mMoPubView.getAdHeight());
    }

    void loadAd() {
        if (this.isInvalidated() || this.mCustomEventBanner == null) {
            return;
        }
        if (this.getTimeoutDelayMilliseconds() > 0) {
            this.mHandler.postDelayed(this.mTimeout, (long)this.getTimeoutDelayMilliseconds());
        }
        try {
            this.mCustomEventBanner.loadBanner(this.mContext, this, this.mLocalExtras, this.mServerExtras);
        }
        catch (Exception e) {
            MoPubLog.d("Loading a custom event banner threw an exception.", e);
            this.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    void invalidate() {
        if (this.mCustomEventBanner != null) {
            try {
                this.mCustomEventBanner.onInvalidate();
            }
            catch (Exception e) {
                MoPubLog.d("Invalidating a custom event banner threw an exception", e);
            }
        }
        this.mContext = null;
        this.mCustomEventBanner = null;
        this.mLocalExtras = null;
        this.mServerExtras = null;
        this.mInvalidated = true;
    }

    boolean isInvalidated() {
        return this.mInvalidated;
    }

    private void cancelTimeout() {
        this.mHandler.removeCallbacks(this.mTimeout);
    }

    private int getTimeoutDelayMilliseconds() {
        if (this.mMoPubView == null || this.mMoPubView.getAdTimeoutDelay() == null || this.mMoPubView.getAdTimeoutDelay() < 0) {
            return 10000;
        }
        return this.mMoPubView.getAdTimeoutDelay() * 1000;
    }

    @Override
    public void onBannerLoaded(View bannerView) {
        if (this.isInvalidated()) {
            return;
        }
        this.cancelTimeout();
        if (this.mMoPubView != null) {
            this.mMoPubView.nativeAdLoaded();
            this.mMoPubView.setAdContentView(bannerView);
            if (!(bannerView instanceof HtmlBannerWebView)) {
                this.mMoPubView.trackNativeImpression();
            }
        }
    }

    @Override
    public void onBannerFailed(MoPubErrorCode errorCode) {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mMoPubView != null) {
            if (errorCode == null) {
                errorCode = MoPubErrorCode.UNSPECIFIED;
            }
            this.cancelTimeout();
            this.mMoPubView.loadFailUrl(errorCode);
        }
    }

    @Override
    public void onBannerExpanded() {
        if (this.isInvalidated()) {
            return;
        }
        this.mStoredAutorefresh = this.mMoPubView.getAutorefreshEnabled();
        this.mMoPubView.setAutorefreshEnabled(false);
        this.mMoPubView.adPresentedOverlay();
    }

    @Override
    public void onBannerCollapsed() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMoPubView.setAutorefreshEnabled(this.mStoredAutorefresh);
        this.mMoPubView.adClosed();
    }

    @Override
    public void onBannerClicked() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mMoPubView != null) {
            this.mMoPubView.registerClick();
        }
    }

    @Override
    public void onLeaveApplication() {
        this.onBannerClicked();
    }
}

