/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.mopub.common.util.VersionCode;
import com.mopub.common.util.Views;
import com.mopub.mobileads.util.WebViews;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared = false;
    protected boolean mIsDestroyed;

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.enablePlugins(false);
        WebViews.setDisableJSChromeClient(this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    protected void enablePlugins(boolean enabled) {
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.JELLY_BEAN_MR2)) {
            return;
        }
        if (enabled) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        } else {
            this.getSettings().setPluginState(WebSettings.PluginState.OFF);
        }
    }

    public void destroy() {
        this.mIsDestroyed = true;
        Views.removeFromParent((View)this);
        this.removeAllViews();
        super.destroy();
    }

    @Deprecated
    void setIsDestroyed(boolean isDestroyed) {
        this.mIsDestroyed = isDestroyed;
    }

    private void clearWebViewDeadlock(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = 1;
            params.height = 1;
            params.type = 2005;
            params.flags = 0x1000018;
            params.format = -2;
            params.gravity = 0x800033;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.addView((View)webView, (ViewGroup.LayoutParams)params);
        }
    }
}

