/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.VastVideoConfig;
import java.io.Serializable;

public class BaseVideoPlayerActivity
extends Activity {
    static final String VIDEO_CLASS_EXTRAS_KEY = "video_view_class_name";
    public static final String VIDEO_URL = "video_url";

    public static void startMraid(Context context, String videoUrl) {
        Intent intentVideoPlayerActivity = BaseVideoPlayerActivity.createIntentMraid(context, videoUrl);
        try {
            context.startActivity(intentVideoPlayerActivity);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.d("Activity MraidVideoPlayerActivity not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    static Intent createIntentMraid(Context context, String videoUrl) {
        Intent intentVideoPlayerActivity = new Intent(context, MraidVideoPlayerActivity.class);
        intentVideoPlayerActivity.setFlags(0x10000000);
        intentVideoPlayerActivity.putExtra(VIDEO_CLASS_EXTRAS_KEY, "mraid");
        intentVideoPlayerActivity.putExtra(VIDEO_URL, videoUrl);
        return intentVideoPlayerActivity;
    }

    static void startVast(Context context, VastVideoConfig vastVideoConfig, long broadcastIdentifier) {
        Intent intentVideoPlayerActivity = BaseVideoPlayerActivity.createIntentVast(context, vastVideoConfig, broadcastIdentifier);
        try {
            context.startActivity(intentVideoPlayerActivity);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.d("Activity MraidVideoPlayerActivity not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    static Intent createIntentVast(Context context, VastVideoConfig vastVideoConfig, long broadcastIdentifier) {
        Intent intentVideoPlayerActivity = new Intent(context, MraidVideoPlayerActivity.class);
        intentVideoPlayerActivity.setFlags(0x10000000);
        intentVideoPlayerActivity.putExtra(VIDEO_CLASS_EXTRAS_KEY, "vast");
        intentVideoPlayerActivity.putExtra("vast_video_config", (Serializable)vastVideoConfig);
        intentVideoPlayerActivity.putExtra("broadcastIdentifier", broadcastIdentifier);
        return intentVideoPlayerActivity;
    }
}

