/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.VersionCode;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.ViewGestureDetector;

public class BaseHtmlWebView
extends BaseWebView
implements ViewGestureDetector.UserClickListener {
    private final ViewGestureDetector mViewGestureDetector;
    private boolean mClicked;

    public BaseHtmlWebView(Context context, AdReport adReport) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.mViewGestureDetector = new ViewGestureDetector(context, (View)this, adReport);
        this.mViewGestureDetector.setUserClickListener(this);
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.ICE_CREAM_SANDWICH)) {
            this.enablePlugins(true);
        }
        this.setBackgroundColor(0);
    }

    public void init(boolean isScrollable) {
        this.initializeOnTouchListener(isScrollable);
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        MoPubLog.d("Loading url: " + url);
        if (url.startsWith("javascript:")) {
            super.loadUrl(url);
        }
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    void loadHtmlResponse(String htmlResponse) {
        this.loadDataWithBaseURL("http://ads.mopub.com/", htmlResponse, "text/html", "utf-8", null);
    }

    void initializeOnTouchListener(final boolean isScrollable) {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                BaseHtmlWebView.this.mViewGestureDetector.sendTouchEvent(event);
                return event.getAction() == 2 && !isScrollable;
            }
        });
    }

    @Override
    public void onUserClick() {
        this.mClicked = true;
    }

    @Override
    public void onResetUserClick() {
        this.mClicked = false;
    }

    @Override
    public boolean wasClicked() {
        return this.mClicked;
    }
}

