/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.MoPubView;
import com.mopub.network.AdResponse;
import java.lang.ref.WeakReference;
import java.util.Map;

abstract class AdLoader {
    WeakReference<AdViewController> mWeakAdViewController;

    AdLoader(AdViewController adViewController) {
        this.mWeakAdViewController = new WeakReference<AdViewController>(adViewController);
    }

    abstract void load();

    @Nullable
    static AdLoader fromAdResponse(AdResponse response, AdViewController adViewController) {
        MoPubLog.i("Performing custom event.");
        String adTypeCustomEventName = response.getCustomEventClassName();
        if (adTypeCustomEventName != null) {
            Map<String, String> customEventData = response.getServerExtras();
            return new CustomEventAdLoader(adViewController, adTypeCustomEventName, customEventData);
        }
        MoPubLog.i("Failed to create custom event.");
        return null;
    }

    static class CustomEventAdLoader
    extends AdLoader {
        private String mCustomEventClassName;
        private Map<String, String> mServerExtras;

        public CustomEventAdLoader(AdViewController adViewController, String customEventCLassName, Map<String, String> serverExtras) {
            super(adViewController);
            this.mCustomEventClassName = customEventCLassName;
            this.mServerExtras = serverExtras;
        }

        @Override
        void load() {
            AdViewController adViewController = (AdViewController)this.mWeakAdViewController.get();
            if (adViewController == null || adViewController.isDestroyed() || TextUtils.isEmpty((CharSequence)this.mCustomEventClassName)) {
                return;
            }
            adViewController.setNotLoading();
            MoPubView moPubView = adViewController.getMoPubView();
            if (moPubView == null) {
                MoPubLog.d("Can't load an ad in this ad view because it was destroyed.");
                return;
            }
            moPubView.loadCustomEvent(this.mCustomEventClassName, this.mServerExtras);
        }

        @VisibleForTesting
        Map<String, String> getServerExtras() {
            return this.mServerExtras;
        }
    }
}

