/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DateAndTime;
import com.mopub.common.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class AdAlertReporter {
    private static final String EMAIL_RECIPIENT = "creative-review@mopub.com";
    private static final String EMAIL_SCHEME = "mailto:";
    private static final String SCREEN_SHOT_FILENAME = "mp_adalert_screenshot.png";
    private static final String PARAMETERS_FILENAME = "mp_adalert_parameters.txt";
    private static final String MARKUP_FILENAME = "mp_adalert_markup.html";
    private static final String DATE_FORMAT_PATTERN = "M/d/yy hh:mm:ss a z";
    private static final int IMAGE_QUALITY = 25;
    private static final String BODY_SEPARATOR = "\n=================\n";
    private final String mDateString;
    private final View mView;
    private final Context mContext;
    private Intent mEmailIntent;
    private ArrayList<Uri> mEmailAttachments;
    private String mParameters;
    private String mResponse;

    public AdAlertReporter(Context context, View view, @Nullable AdReport adReport) {
        this.mView = view;
        this.mContext = context;
        this.mEmailAttachments = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
        this.mDateString = dateFormat.format(DateAndTime.now());
        this.initEmailIntent();
        Bitmap screenShot = this.takeScreenShot();
        String screenShotString = this.convertBitmapInWEBPToBase64EncodedString(screenShot);
        this.mParameters = "";
        this.mResponse = "";
        if (adReport != null) {
            this.mParameters = adReport.toString();
            this.mResponse = adReport.getResponseString();
        }
        this.addEmailSubject();
        this.addEmailBody(this.mParameters, this.mResponse, screenShotString);
        this.addTextAttachment(PARAMETERS_FILENAME, this.mParameters);
        this.addTextAttachment(MARKUP_FILENAME, this.mResponse);
        this.addImageAttachment(SCREEN_SHOT_FILENAME, screenShot);
    }

    public void send() {
        this.mEmailIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.mEmailAttachments);
        Intent chooserIntent = Intent.createChooser((Intent)this.mEmailIntent, (CharSequence)"Send Email...");
        chooserIntent.addFlags(0x10000000);
        this.mContext.startActivity(chooserIntent);
    }

    private void initEmailIntent() {
        Uri emailScheme = Uri.parse((String)EMAIL_SCHEME);
        this.mEmailIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        this.mEmailIntent.setDataAndType(emailScheme, "plain/text");
        this.mEmailIntent.putExtra("android.intent.extra.EMAIL", new String[]{EMAIL_RECIPIENT});
    }

    private Bitmap takeScreenShot() {
        if (this.mView == null || this.mView.getRootView() == null) {
            return null;
        }
        View rootView = this.mView.getRootView();
        boolean wasDrawingCacheEnabled = rootView.isDrawingCacheEnabled();
        rootView.setDrawingCacheEnabled(true);
        Bitmap drawingCache = rootView.getDrawingCache();
        if (drawingCache == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
        rootView.setDrawingCacheEnabled(wasDrawingCacheEnabled);
        return bitmap;
    }

    private String convertBitmapInWEBPToBase64EncodedString(Bitmap bitmap) {
        String result = null;
        if (bitmap != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 25, (OutputStream)byteArrayOutputStream);
                byte[] bytes = byteArrayOutputStream.toByteArray();
                result = Base64.encodeToString((byte[])bytes, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void addEmailSubject() {
        this.mEmailIntent.putExtra("android.intent.extra.SUBJECT", "New creative violation report - " + this.mDateString);
    }

    private void addEmailBody(String ... data) {
        StringBuilder body = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            body.append(data[i]);
            if (i == data.length - 1) continue;
            body.append(BODY_SEPARATOR);
        }
        this.mEmailIntent.putExtra("android.intent.extra.TEXT", body.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImageAttachment(String fileName, Bitmap bitmap) {
        FileOutputStream fileOutputStream = null;
        if (fileName == null || bitmap == null) {
            return;
        }
        try {
            fileOutputStream = this.mContext.openFileOutput(fileName, 1);
            bitmap.compress(Bitmap.CompressFormat.PNG, 25, (OutputStream)fileOutputStream);
            Uri fileUri = Uri.fromFile((File)new File(this.mContext.getFilesDir() + File.separator + fileName));
            this.mEmailAttachments.add(fileUri);
        }
        catch (Exception exception) {
            try {
                MoPubLog.d("Unable to write text attachment to file: " + fileName);
            }
            catch (Throwable throwable) {
                Streams.closeStream(fileOutputStream);
                throw throwable;
            }
            Streams.closeStream(fileOutputStream);
        }
        Streams.closeStream(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTextAttachment(String fileName, String body) {
        FileOutputStream fileOutputStream = null;
        if (fileName == null || body == null) {
            return;
        }
        try {
            fileOutputStream = this.mContext.openFileOutput(fileName, 1);
            fileOutputStream.write(body.getBytes());
            Uri fileUri = Uri.fromFile((File)new File(this.mContext.getFilesDir() + File.separator + fileName));
            this.mEmailAttachments.add(fileUri);
        }
        catch (Exception exception) {
            try {
                MoPubLog.d("Unable to write text attachment to file: " + fileName);
            }
            catch (Throwable throwable) {
                Streams.closeStream(fileOutputStream);
                throw throwable;
            }
            Streams.closeStream(fileOutputStream);
        }
        Streams.closeStream(fileOutputStream);
    }

    @Deprecated
    Intent getEmailIntent() {
        return this.mEmailIntent;
    }

    @Deprecated
    ArrayList<Uri> getEmailAttachments() {
        return this.mEmailAttachments;
    }

    @Deprecated
    String getParameters() {
        return this.mParameters;
    }

    @Deprecated
    String getResponse() {
        return this.mResponse;
    }
}

