/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.mopub.common.Preconditions;

public class Dips {
    public static float pixelsToFloatDips(float pixels, Context context) {
        return pixels / Dips.getDensity(context);
    }

    public static int pixelsToIntDips(float pixels, Context context) {
        return (int)(Dips.pixelsToFloatDips(pixels, context) + 0.5f);
    }

    public static float dipsToFloatPixels(float dips, Context context) {
        return dips * Dips.getDensity(context);
    }

    public static int dipsToIntPixels(float dips, Context context) {
        return (int)(Dips.dipsToFloatPixels(dips, context) + 0.5f);
    }

    private static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static float asFloatPixels(float dips, Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)displayMetrics);
    }

    public static int asIntPixels(float dips, Context context) {
        return (int)(Dips.asFloatPixels(dips, context) + 0.5f);
    }

    public static int screenWidthAsIntDips(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        return Dips.pixelsToIntDips(context.getResources().getDisplayMetrics().widthPixels, context);
    }

    public static int screenHeightAsIntDips(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        return Dips.pixelsToIntDips(context.getResources().getDisplayMetrics().heightPixels, context);
    }
}

