/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.logging;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.util.Log;
import com.mopub.common.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MoPubLog {
    public static final String LOGGER_NAMESPACE = "com.mopub";
    private static final String LOGTAG = "MoPub";
    private static final Logger LOGGER = Logger.getLogger("com.mopub");
    private static final MoPubLogHandler LOG_HANDLER = new MoPubLogHandler();

    private MoPubLog() {
    }

    public static void c(String message) {
        MoPubLog.c(message, null);
    }

    public static void v(String message) {
        MoPubLog.v(message, null);
    }

    public static void d(String message) {
        MoPubLog.d(message, null);
    }

    public static void i(String message) {
        MoPubLog.i(message, null);
    }

    public static void w(String message) {
        MoPubLog.w(message, null);
    }

    public static void e(String message) {
        MoPubLog.e(message, null);
    }

    public static void c(String message, Throwable throwable) {
        LOGGER.log(Level.FINEST, message, throwable);
    }

    public static void v(String message, Throwable throwable) {
        LOGGER.log(Level.FINE, message, throwable);
    }

    public static void d(String message, Throwable throwable) {
        LOGGER.log(Level.CONFIG, message, throwable);
    }

    public static void i(String message, Throwable throwable) {
        LOGGER.log(Level.INFO, message, throwable);
    }

    public static void w(String message, Throwable throwable) {
        LOGGER.log(Level.WARNING, message, throwable);
    }

    public static void e(String message, Throwable throwable) {
        LOGGER.log(Level.SEVERE, message, throwable);
    }

    @VisibleForTesting
    public static void setSdkHandlerLevel(@NonNull Level level) {
        LOG_HANDLER.setLevel(level);
    }

    private static void addHandler(@NonNull Logger logger, @NonNull Handler handler) {
        Handler[] currentHandlers;
        for (Handler currentHandler : currentHandlers = logger.getHandlers()) {
            if (!currentHandler.equals(handler)) continue;
            return;
        }
        logger.addHandler(handler);
    }

    static {
        LOGGER.setUseParentHandlers(false);
        LOGGER.setLevel(Level.ALL);
        LOG_HANDLER.setLevel(Level.FINE);
        LogManager.getLogManager().addLogger(LOGGER);
        MoPubLog.addHandler(LOGGER, LOG_HANDLER);
    }

    private static final class MoPubLogHandler
    extends Handler {
        private static final Map<Level, Integer> LEVEL_TO_LOG = new HashMap<Level, Integer>(7);

        private MoPubLogHandler() {
        }

        @Override
        @SuppressLint(value={"LogTagMismatch"})
        public void publish(LogRecord logRecord) {
            if (this.isLoggable(logRecord)) {
                int priority = LEVEL_TO_LOG.containsKey(logRecord.getLevel()) ? LEVEL_TO_LOG.get(logRecord.getLevel()) : 2;
                String message = logRecord.getMessage() + "\n";
                Throwable error = logRecord.getThrown();
                if (error != null) {
                    message = message + Log.getStackTraceString((Throwable)error);
                }
                Log.println((int)priority, (String)MoPubLog.LOGTAG, (String)message);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        static {
            LEVEL_TO_LOG.put(Level.FINEST, 2);
            LEVEL_TO_LOG.put(Level.FINER, 2);
            LEVEL_TO_LOG.put(Level.FINE, 2);
            LEVEL_TO_LOG.put(Level.CONFIG, 3);
            LEVEL_TO_LOG.put(Level.INFO, 4);
            LEVEL_TO_LOG.put(Level.WARNING, 5);
            LEVEL_TO_LOG.put(Level.SEVERE, 6);
        }
    }
}

