/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.UrlAction;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.AsyncTasks;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

@VisibleForTesting
public class UrlResolutionTask
extends AsyncTask<String, Void, String> {
    private static final int REDIRECT_LIMIT = 10;
    @NonNull
    private final UrlResolutionListener mListener;

    public static void getResolvedUrl(@NonNull String urlString, @NonNull UrlResolutionListener listener) {
        UrlResolutionTask urlResolutionTask = new UrlResolutionTask(listener);
        try {
            AsyncTasks.safeExecuteOnExecutor(urlResolutionTask, urlString);
        }
        catch (Exception e) {
            listener.onFailure("Failed to resolve url", e);
        }
    }

    UrlResolutionTask(@NonNull UrlResolutionListener listener) {
        this.mListener = listener;
    }

    @Nullable
    protected String doInBackground(String ... urls) {
        if (urls == null || urls.length == 0) {
            return null;
        }
        String previousUrl = null;
        try {
            String locationUrl = urls[0];
            for (int redirectCount = 0; locationUrl != null && redirectCount < 10; ++redirectCount) {
                if (!UrlAction.OPEN_IN_APP_BROWSER.shouldTryHandlingUrl(Uri.parse((String)locationUrl))) {
                    return locationUrl;
                }
                previousUrl = locationUrl;
                locationUrl = this.getRedirectLocation(locationUrl);
            }
        }
        catch (IOException e) {
            return null;
        }
        return previousUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getRedirectLocation(@NonNull String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection httpUrlConnection = null;
        try {
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setInstanceFollowRedirects(false);
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode >= 300 && responseCode < 400) {
                String string = httpUrlConnection.getHeaderField("Location");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    protected void onPostExecute(@Nullable String resolvedUrl) {
        super.onPostExecute((Object)resolvedUrl);
        if (this.isCancelled() || resolvedUrl == null) {
            this.onCancelled();
        } else {
            this.mListener.onSuccess(resolvedUrl);
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        this.mListener.onFailure("Task for resolving url was cancelled", null);
    }

    static interface UrlResolutionListener {
        public void onSuccess(@NonNull String var1);

        public void onFailure(@NonNull String var1, @Nullable Throwable var2);
    }
}

