/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlHandler;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Intents;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.exceptions.UrlParseException;
import com.mopub.network.TrackingRequest;
import java.util.List;

public enum UrlAction {
    HANDLE_MOPUB_SCHEME(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "mopub".equals(uri.getScheme());
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            String host = uri.getHost();
            UrlHandler.MoPubSchemeListener moPubSchemeListener = urlHandler.getMoPubSchemeListener();
            if ("finishLoad".equals(host)) {
                moPubSchemeListener.onFinishLoad();
            } else if ("close".equals(host)) {
                moPubSchemeListener.onClose();
            } else if ("failLoad".equals(host)) {
                moPubSchemeListener.onFailLoad();
            } else {
                throw new IntentNotResolvableException("Could not handle MoPub Scheme url: " + uri);
            }
        }
    }
    ,
    IGNORE_ABOUT_SCHEME(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "about".equals(uri.getScheme());
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            MoPubLog.d("Link to about page ignored.");
        }
    }
    ,
    HANDLE_PHONE_SCHEME(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String scheme = uri.getScheme();
            return "tel".equals(scheme) || "voicemail".equals(scheme) || "sms".equals(scheme) || "mailto".equals(scheme) || "geo".equals(scheme) || "google.streetview".equals(scheme);
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            String errorMessage = "Could not handle intent with URI: " + uri + "\n\tIs " + "this intent supported on your phone?";
            Intents.launchActionViewIntent(context, uri, errorMessage);
        }
    }
    ,
    OPEN_NATIVE_BROWSER(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "mopubnativebrowser".equals(uri.getScheme());
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            String errorMessage = "Unable to load mopub native browser url: " + uri;
            try {
                Intent intent = Intents.intentForNativeBrowserScheme(uri);
                Intents.launchIntentForUserClick(context, intent, errorMessage);
            }
            catch (UrlParseException e) {
                throw new IntentNotResolvableException(errorMessage + "\n\t" + e.getMessage());
            }
        }
    }
    ,
    OPEN_APP_MARKET(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            return "play.google.com".equals(host) || "market.android.com".equals(host) || "market".equals(scheme) || uri.toString().startsWith("play.google.com/") || uri.toString().startsWith("market.android.com/");
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            Intents.launchApplicationUrl(context, uri);
        }
    }
    ,
    OPEN_IN_APP_BROWSER(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String scheme = uri.getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            if (!urlHandler.shouldSkipShowMoPubBrowser()) {
                Intents.showMoPubBrowserForUrl(context, uri);
            }
        }
    }
    ,
    HANDLE_SHARE_TWEET(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            Preconditions.checkNotNull(uri);
            return "mopubshare".equals(uri.getScheme()) && "tweet".equals(uri.getHost());
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(uri);
            String chooserText = "Share via";
            String errorMessage = "Could not handle share tweet intent with URI " + uri;
            try {
                Intent shareTweetIntent = Intents.intentForShareTweet(uri);
                Intent chooserIntent = Intent.createChooser((Intent)shareTweetIntent, (CharSequence)"Share via");
                Intents.launchIntentForUserClick(context, chooserIntent, errorMessage);
            }
            catch (UrlParseException e) {
                throw new IntentNotResolvableException(errorMessage + "\n\t" + e.getMessage());
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK_WITH_FALLBACK(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "deeplink+".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            List fallbackTrackingUrls;
            String fallbackUrl;
            List primaryTrackingUrls;
            String primaryUrl;
            if (!"navigate".equalsIgnoreCase(uri.getHost())) {
                throw new IntentNotResolvableException("Deeplink+ URL did not have 'navigate' as the host.");
            }
            try {
                primaryUrl = uri.getQueryParameter("primaryUrl");
                primaryTrackingUrls = uri.getQueryParameters("primaryTrackingUrl");
                fallbackUrl = uri.getQueryParameter("fallbackUrl");
                fallbackTrackingUrls = uri.getQueryParameters("fallbackTrackingUrl");
            }
            catch (UnsupportedOperationException e) {
                throw new IntentNotResolvableException("Deeplink+ URL was not a hierarchical URI.");
            }
            if (primaryUrl == null) {
                throw new IntentNotResolvableException("Deeplink+ did not have 'primaryUrl' query param.");
            }
            Uri primaryUri = Uri.parse((String)primaryUrl);
            if (this.shouldTryHandlingUrl(primaryUri)) {
                throw new IntentNotResolvableException("Deeplink+ had another Deeplink+ as the 'primaryUrl'.");
            }
            try {
                Intents.launchApplicationUrl(context, primaryUri);
                TrackingRequest.makeTrackingHttpRequest(primaryTrackingUrls, context, BaseEvent.Name.CLICK_REQUEST);
                return;
            }
            catch (IntentNotResolvableException e) {
                if (fallbackUrl == null) {
                    throw new IntentNotResolvableException("Unable to handle 'primaryUrl' for Deeplink+ and 'fallbackUrl' was missing.");
                }
                if (this.shouldTryHandlingUrl(Uri.parse((String)fallbackUrl))) {
                    throw new IntentNotResolvableException("Deeplink+ URL had another Deeplink+ URL as the 'fallbackUrl'.");
                }
                boolean fromUserInteraction = true;
                urlHandler.handleUrl(context, fallbackUrl, true, fallbackTrackingUrls);
                return;
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            return !TextUtils.isEmpty((CharSequence)scheme) && !TextUtils.isEmpty((CharSequence)host);
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
            Intents.launchApplicationUrl(context, uri);
        }
    }
    ,
    NOOP(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return false;
        }

        @Override
        protected void performAction(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler) throws IntentNotResolvableException {
        }
    };

    private final boolean mRequiresUserInteraction;

    public void handleUrl(UrlHandler urlHandler, @NonNull Context context, @NonNull Uri destinationUri, boolean fromUserInteraction) throws IntentNotResolvableException {
        MoPubLog.d("Ad event URL: " + destinationUri);
        if (this.mRequiresUserInteraction && !fromUserInteraction) {
            throw new IntentNotResolvableException("Attempted to handle action without user interaction.");
        }
        this.performAction(context, destinationUri, urlHandler);
    }

    private UrlAction(boolean requiresUserInteraction) {
        this.mRequiresUserInteraction = requiresUserInteraction;
    }

    public abstract boolean shouldTryHandlingUrl(@NonNull Uri var1);

    protected abstract void performAction(@NonNull Context var1, @NonNull Uri var2, @NonNull UrlHandler var3) throws IntentNotResolvableException;
}

