/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.mopub.common.BrowserWebViewClient;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Drawables;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.util.WebViews;

public class MoPubBrowser
extends Activity {
    public static final String DESTINATION_URL_KEY = "URL";
    private static final int INNER_LAYOUT_ID = 1;
    private WebView mWebView;
    private ImageButton mBackButton;
    private ImageButton mForwardButton;
    private ImageButton mRefreshButton;
    private ImageButton mCloseButton;

    @NonNull
    public ImageButton getBackButton() {
        return this.mBackButton;
    }

    @NonNull
    public ImageButton getCloseButton() {
        return this.mCloseButton;
    }

    @NonNull
    public ImageButton getForwardButton() {
        return this.mForwardButton;
    }

    @NonNull
    public ImageButton getRefreshButton() {
        return this.mRefreshButton;
    }

    @NonNull
    public WebView getWebView() {
        return this.mWebView;
    }

    public static void open(Context context, String url) {
        MoPubLog.d("Opening url in MoPubBrowser: " + url);
        Intent intent = new Intent(context, MoPubBrowser.class);
        intent.putExtra(DESTINATION_URL_KEY, url);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setResult(-1);
        this.getWindow().requestFeature(2);
        this.getWindow().setFeatureInt(2, -1);
        this.setContentView(this.getMoPubBrowserView());
        this.initializeWebView();
        this.initializeButtons();
        this.enableCookies();
    }

    private void initializeWebView() {
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        this.mWebView.loadUrl(this.getIntent().getStringExtra(DESTINATION_URL_KEY));
        this.mWebView.setWebViewClient((WebViewClient)new BrowserWebViewClient(this));
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int progress) {
                MoPubBrowser.this.setTitle("Loading...");
                MoPubBrowser.this.setProgress(progress * 100);
                if (progress == 100) {
                    MoPubBrowser.this.setTitle(webView.getUrl());
                }
            }
        });
    }

    private void initializeButtons() {
        this.mBackButton.setBackgroundColor(0);
        this.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MoPubBrowser.this.mWebView.canGoBack()) {
                    MoPubBrowser.this.mWebView.goBack();
                }
            }
        });
        this.mForwardButton.setBackgroundColor(0);
        this.mForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MoPubBrowser.this.mWebView.canGoForward()) {
                    MoPubBrowser.this.mWebView.goForward();
                }
            }
        });
        this.mRefreshButton.setBackgroundColor(0);
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MoPubBrowser.this.mWebView.reload();
            }
        });
        this.mCloseButton.setBackgroundColor(0);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MoPubBrowser.this.finish();
            }
        });
    }

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().startSync();
    }

    protected void onPause() {
        super.onPause();
        CookieSyncManager.getInstance().stopSync();
        WebViews.onPause(this.mWebView, this.isFinishing());
    }

    protected void onResume() {
        super.onResume();
        CookieSyncManager.getInstance().startSync();
        WebViews.onResume(this.mWebView);
    }

    public void finish() {
        ViewGroup decorView = (ViewGroup)this.getWindow().getDecorView();
        decorView.removeAllViews();
        super.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWebView.destroy();
        this.mWebView = null;
    }

    private View getMoPubBrowserView() {
        LinearLayout moPubBrowserView = new LinearLayout((Context)this);
        LinearLayout.LayoutParams browserLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        moPubBrowserView.setLayoutParams((ViewGroup.LayoutParams)browserLayoutParams);
        moPubBrowserView.setOrientation(1);
        RelativeLayout outerLayout = new RelativeLayout((Context)this);
        LinearLayout.LayoutParams outerLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        outerLayout.setLayoutParams((ViewGroup.LayoutParams)outerLayoutParams);
        moPubBrowserView.addView((View)outerLayout);
        LinearLayout innerLayout = new LinearLayout((Context)this);
        innerLayout.setId(1);
        RelativeLayout.LayoutParams innerLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
        innerLayoutParams.addRule(12);
        innerLayout.setLayoutParams((ViewGroup.LayoutParams)innerLayoutParams);
        innerLayout.setBackgroundDrawable(Drawables.BACKGROUND.createDrawable((Context)this));
        outerLayout.addView((View)innerLayout);
        this.mBackButton = this.getButton(Drawables.LEFT_ARROW.createDrawable((Context)this));
        this.mForwardButton = this.getButton(Drawables.RIGHT_ARROW.createDrawable((Context)this));
        this.mRefreshButton = this.getButton(Drawables.REFRESH.createDrawable((Context)this));
        this.mCloseButton = this.getButton(Drawables.CLOSE.createDrawable((Context)this));
        innerLayout.addView((View)this.mBackButton);
        innerLayout.addView((View)this.mForwardButton);
        innerLayout.addView((View)this.mRefreshButton);
        innerLayout.addView((View)this.mCloseButton);
        this.mWebView = new BaseWebView((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(2, 1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        outerLayout.addView((View)this.mWebView);
        return moPubBrowserView;
    }

    private ImageButton getButton(Drawable drawable) {
        ImageButton imageButton = new ImageButton((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        layoutParams.gravity = 16;
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageButton.setImageDrawable(drawable);
        return imageButton;
    }

    @Deprecated
    @VisibleForTesting
    void setWebView(WebView webView) {
        this.mWebView = webView;
    }
}

