/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.ResponseHeader;
import com.mopub.network.Networking;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClient {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;

    public static AndroidHttpClient getHttpClient() {
        String userAgent = Networking.getCachedUserAgent();
        AndroidHttpClient httpClient = AndroidHttpClient.newInstance((String)userAgent);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        return httpClient;
    }

    public static HttpGet initializeHttpGet(@NonNull String url) {
        return HttpClient.initializeHttpGet(url, null);
    }

    public static HttpGet initializeHttpGet(@NonNull String url, @Nullable Context context) {
        String getUrl;
        Preconditions.checkNotNull(url);
        try {
            getUrl = HttpClient.urlEncode(url);
        }
        catch (Exception e) {
            getUrl = url;
        }
        HttpGet httpGet = new HttpGet(getUrl);
        String webViewUserAgent = context != null ? Networking.getUserAgent(context) : Networking.getCachedUserAgent();
        if (webViewUserAgent != null) {
            httpGet.addHeader(ResponseHeader.USER_AGENT.getKey(), webViewUserAgent);
        }
        return httpGet;
    }

    public static String urlEncode(@NonNull String url) throws Exception {
        Preconditions.checkNotNull(url);
        if (HttpClient.isUrlImproperlyEncoded(url)) {
            throw new UnsupportedEncodingException("URL is improperly encoded: " + url);
        }
        URI uri = HttpClient.isUrlUnencoded(url) ? HttpClient.encodeUrl(url) : new URI(url);
        return uri.toURL().toString();
    }

    static boolean isUrlImproperlyEncoded(@NonNull String url) {
        try {
            URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MoPubLog.w("Url is improperly encoded: " + url);
            return true;
        }
        return false;
    }

    static boolean isUrlUnencoded(@NonNull String url) {
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return true;
        }
        return false;
    }

    static URI encodeUrl(@NonNull String urlString) throws Exception {
        URI uri;
        try {
            URL url = new URL(urlString);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (Exception e) {
            MoPubLog.w("Failed to encode url: " + urlString);
            throw e;
        }
        return uri;
    }
}

