/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import com.mopub.common.DownloadResponse;
import com.mopub.common.HttpClient;
import com.mopub.common.logging.MoPubLog;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class DownloadTask
extends AsyncTask<HttpUriRequest, Void, DownloadResponse> {
    private final DownloadTaskListener mDownloadTaskListener;
    private String mUrl;

    public DownloadTask(DownloadTaskListener downloadTaskListener) throws IllegalArgumentException {
        if (downloadTaskListener == null) {
            throw new IllegalArgumentException("DownloadTaskListener must not be null.");
        }
        this.mDownloadTaskListener = downloadTaskListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadResponse doInBackground(HttpUriRequest ... httpUriRequests) {
        if (httpUriRequests == null || httpUriRequests.length == 0 || httpUriRequests[0] == null) {
            MoPubLog.d("Download task tried to execute null or empty url");
            return null;
        }
        HttpUriRequest httpUriRequest = httpUriRequests[0];
        this.mUrl = httpUriRequest.getURI().toString();
        try (AndroidHttpClient httpClient = null;){
            httpClient = HttpClient.getHttpClient();
            HttpResponse httpResponse = httpClient.execute(httpUriRequest);
            DownloadResponse downloadResponse = new DownloadResponse(httpResponse);
            return downloadResponse;
        }
    }

    protected void onPostExecute(DownloadResponse downloadResponse) {
        if (this.isCancelled()) {
            this.onCancelled();
            return;
        }
        this.mDownloadTaskListener.onComplete(this.mUrl, downloadResponse);
    }

    protected void onCancelled() {
        MoPubLog.d("DownloadTask was cancelled.");
    }

    public static interface DownloadTaskListener {
        public void onComplete(String var1, DownloadResponse var2);
    }
}

