/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import java.util.Locale;

public class ClientMetadata {
    private static final int TYPE_ETHERNET = 9;
    private static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    private static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    private static final String DEVICE_ORIENTATION_SQUARE = "s";
    private static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    private static final String IFA_PREFIX = "ifa:";
    private static final String SHA_PREFIX = "sha:";
    private static final int UNKNOWN_NETWORK = -1;
    private String mNetworkOperatorForUrl;
    private final String mNetworkOperator;
    private String mSimOperator;
    private final String mIsoCountryCode;
    private final String mSimIsoCountryCode;
    private String mNetworkOperatorName;
    private String mSimOperatorName;
    private String mUdid;
    private boolean mDoNotTrack = false;
    private boolean mAdvertisingInfoSet = false;
    private static volatile ClientMetadata sInstance;
    private final String mDeviceManufacturer;
    private final String mDeviceModel;
    private final String mDeviceProduct;
    private final String mDeviceOsVersion;
    private final String mSdkVersion;
    private final String mAppVersion;
    private final String mAppPackageName;
    private String mAppName;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientMetadata getInstance(Context context) {
        ClientMetadata result = sInstance;
        if (result != null) return result;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            result = sInstance;
            if (result != null) return result;
            sInstance = result = new ClientMetadata(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientMetadata getInstance() {
        ClientMetadata result = sInstance;
        if (result != null) return result;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            return sInstance;
        }
    }

    public ClientMetadata(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.mDeviceManufacturer = Build.MANUFACTURER;
        this.mDeviceModel = Build.MODEL;
        this.mDeviceProduct = Build.PRODUCT;
        this.mDeviceOsVersion = Build.VERSION.RELEASE;
        this.mSdkVersion = "3.11.0";
        this.mAppVersion = ClientMetadata.getAppVersionFromContext(this.mContext);
        PackageManager packageManager = this.mContext.getPackageManager();
        ApplicationInfo applicationInfo = null;
        this.mAppPackageName = context.getPackageName();
        try {
            applicationInfo = packageManager.getApplicationInfo(this.mAppPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        if (applicationInfo != null) {
            this.mAppName = (String)packageManager.getApplicationLabel(applicationInfo);
        }
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mNetworkOperatorForUrl = telephonyManager.getNetworkOperator();
        this.mNetworkOperator = telephonyManager.getNetworkOperator();
        if (telephonyManager.getPhoneType() == 2 && telephonyManager.getSimState() == 5) {
            this.mNetworkOperatorForUrl = telephonyManager.getSimOperator();
            this.mSimOperator = telephonyManager.getSimOperator();
        }
        this.mIsoCountryCode = telephonyManager.getNetworkCountryIso();
        this.mSimIsoCountryCode = telephonyManager.getSimCountryIso();
        try {
            this.mNetworkOperatorName = telephonyManager.getNetworkOperatorName();
            if (telephonyManager.getSimState() == 5) {
                this.mSimOperatorName = telephonyManager.getSimOperatorName();
            }
        }
        catch (SecurityException e) {
            this.mNetworkOperatorName = null;
            this.mSimOperatorName = null;
        }
        this.mUdid = ClientMetadata.getDeviceIdFromContext(this.mContext);
    }

    private static String getAppVersionFromContext(Context context) {
        try {
            String packageName = context.getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            MoPubLog.d("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    private static String getDeviceIdFromContext(Context context) {
        String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        deviceId = deviceId == null ? "" : Utils.sha1(deviceId);
        return SHA_PREFIX + deviceId;
    }

    public String getOrientationString() {
        int orientationInt = this.mContext.getResources().getConfiguration().orientation;
        String orientation = DEVICE_ORIENTATION_UNKNOWN;
        if (orientationInt == 1) {
            orientation = DEVICE_ORIENTATION_PORTRAIT;
        } else if (orientationInt == 2) {
            orientation = DEVICE_ORIENTATION_LANDSCAPE;
        } else if (orientationInt == 3) {
            orientation = DEVICE_ORIENTATION_SQUARE;
        }
        return orientation;
    }

    public MoPubNetworkType getActiveNetworkType() {
        int networkType = -1;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0) {
            NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            networkType = activeNetworkInfo != null ? activeNetworkInfo.getType() : -1;
        }
        return MoPubNetworkType.fromAndroidNetworkType(networkType);
    }

    public float getDensity() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    public String getNetworkOperatorForUrl() {
        return this.mNetworkOperatorForUrl;
    }

    public String getNetworkOperator() {
        return this.mNetworkOperator;
    }

    public Locale getDeviceLocale() {
        return this.mContext.getResources().getConfiguration().locale;
    }

    public String getSimOperator() {
        return this.mSimOperator;
    }

    public String getIsoCountryCode() {
        return this.mIsoCountryCode;
    }

    public String getSimIsoCountryCode() {
        return this.mSimIsoCountryCode;
    }

    public String getNetworkOperatorName() {
        return this.mNetworkOperatorName;
    }

    public String getSimOperatorName() {
        return this.mSimOperatorName;
    }

    public synchronized String getDeviceId() {
        return this.mUdid;
    }

    public synchronized boolean isDoNotTrackSet() {
        return this.mDoNotTrack;
    }

    public synchronized void setAdvertisingInfo(String advertisingId, boolean doNotTrack) {
        this.mUdid = IFA_PREFIX + advertisingId;
        this.mDoNotTrack = doNotTrack;
        this.mAdvertisingInfoSet = true;
    }

    public synchronized boolean isAdvertisingInfoSet() {
        return this.mAdvertisingInfoSet;
    }

    public String getDeviceManufacturer() {
        return this.mDeviceManufacturer;
    }

    public String getDeviceModel() {
        return this.mDeviceModel;
    }

    public String getDeviceProduct() {
        return this.mDeviceProduct;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public int getDeviceScreenWidthDip() {
        return Dips.screenWidthAsIntDips(this.mContext);
    }

    public int getDeviceScreenHeightDip() {
        return Dips.screenHeightAsIntDips(this.mContext);
    }

    public Point getDeviceDimensions() {
        if (Preconditions.NoThrow.checkNotNull(this.mContext)) {
            return DeviceUtils.getDeviceDimensions(this.mContext);
        }
        return new Point(0, 0);
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getAppName() {
        return this.mAppName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    public static void setInstance(ClientMetadata clientMetadata) {
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            sInstance = clientMetadata;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static void clearForTesting() {
        sInstance = null;
    }

    public static enum MoPubNetworkType {
        UNKNOWN(0),
        ETHERNET(1),
        WIFI(2),
        MOBILE(3);

        private final int mId;

        private MoPubNetworkType(int id) {
            this.mId = id;
        }

        public String toString() {
            return Integer.toString(this.mId);
        }

        private static MoPubNetworkType fromAndroidNetworkType(int type) {
            switch (type) {
                case 9: {
                    return ETHERNET;
                }
                case 1: {
                    return WIFI;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return MOBILE;
                }
            }
            return UNKNOWN;
        }

        public int getId() {
            return this.mId;
        }
    }
}

