/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.location.Location;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.LocationService;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.util.DateAndTime;

public abstract class AdUrlGenerator
extends BaseUrlGenerator {
    private static final String AD_UNIT_ID_KEY = "id";
    private static final String SDK_VERSION_KEY = "nv";
    private static final String KEYWORDS_KEY = "q";
    private static final String LAT_LONG_KEY = "ll";
    private static final String LAT_LONG_ACCURACY_KEY = "lla";
    private static final String LAT_LONG_FRESHNESS_KEY = "llf";
    private static final String LAT_LONG_FROM_SDK_KEY = "llsdk";
    private static final String TIMEZONE_OFFSET_KEY = "z";
    private static final String ORIENTATION_KEY = "o";
    private static final String SCREEN_SCALE_KEY = "sc_a";
    private static final String IS_MRAID_KEY = "mr";
    private static final String MOBILE_COUNTRY_CODE_KEY = "mcc";
    private static final String MOBILE_NETWORK_CODE_KEY = "mnc";
    private static final String COUNTRY_CODE_KEY = "iso";
    private static final String CARRIER_NAME_KEY = "cn";
    private static final String CARRIER_TYPE_KEY = "ct";
    private static final String BUNDLE_ID_KEY = "bundle";
    protected Context mContext;
    protected String mAdUnitId;
    protected String mKeywords;
    protected Location mLocation;

    public AdUrlGenerator(Context context) {
        this.mContext = context;
    }

    public AdUrlGenerator withAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    public AdUrlGenerator withKeywords(String keywords) {
        this.mKeywords = keywords;
        return this;
    }

    public AdUrlGenerator withLocation(Location location) {
        this.mLocation = location;
        return this;
    }

    protected void setAdUnitId(String adUnitId) {
        this.addParam(AD_UNIT_ID_KEY, adUnitId);
    }

    protected void setSdkVersion(String sdkVersion) {
        this.addParam(SDK_VERSION_KEY, sdkVersion);
    }

    protected void setKeywords(String keywords) {
        this.addParam(KEYWORDS_KEY, keywords);
    }

    protected void setLocation(@Nullable Location location) {
        Location bestLocation = location;
        Location locationFromLocationService = LocationService.getLastKnownLocation(this.mContext, MoPub.getLocationPrecision(), MoPub.getLocationAwareness());
        if (locationFromLocationService != null && (location == null || locationFromLocationService.getTime() >= location.getTime())) {
            bestLocation = locationFromLocationService;
        }
        if (bestLocation != null) {
            this.addParam(LAT_LONG_KEY, bestLocation.getLatitude() + "," + bestLocation.getLongitude());
            this.addParam(LAT_LONG_ACCURACY_KEY, String.valueOf((int)bestLocation.getAccuracy()));
            this.addParam(LAT_LONG_FRESHNESS_KEY, String.valueOf(AdUrlGenerator.calculateLocationStalenessInMilliseconds(bestLocation)));
            if (bestLocation == locationFromLocationService) {
                this.addParam(LAT_LONG_FROM_SDK_KEY, "1");
            }
        }
    }

    protected void setTimezone(String timeZoneOffsetString) {
        this.addParam(TIMEZONE_OFFSET_KEY, timeZoneOffsetString);
    }

    protected void setOrientation(String orientation) {
        this.addParam(ORIENTATION_KEY, orientation);
    }

    protected void setDensity(float density) {
        this.addParam(SCREEN_SCALE_KEY, "" + density);
    }

    protected void setMraidFlag(boolean mraid) {
        if (mraid) {
            this.addParam(IS_MRAID_KEY, "1");
        }
    }

    protected void setMccCode(String networkOperator) {
        String mcc = networkOperator == null ? "" : networkOperator.substring(0, this.mncPortionLength(networkOperator));
        this.addParam(MOBILE_COUNTRY_CODE_KEY, mcc);
    }

    protected void setMncCode(String networkOperator) {
        String mnc = networkOperator == null ? "" : networkOperator.substring(this.mncPortionLength(networkOperator));
        this.addParam(MOBILE_NETWORK_CODE_KEY, mnc);
    }

    protected void setIsoCountryCode(String networkCountryIso) {
        this.addParam(COUNTRY_CODE_KEY, networkCountryIso);
    }

    protected void setCarrierName(String networkOperatorName) {
        this.addParam(CARRIER_NAME_KEY, networkOperatorName);
    }

    protected void setNetworkType(ClientMetadata.MoPubNetworkType networkType) {
        this.addParam(CARRIER_TYPE_KEY, networkType);
    }

    protected void setBundleId(String bundleId) {
        if (!TextUtils.isEmpty((CharSequence)bundleId)) {
            this.addParam(BUNDLE_ID_KEY, bundleId);
        }
    }

    protected void addBaseParams(ClientMetadata clientMetadata) {
        this.setAdUnitId(this.mAdUnitId);
        this.setSdkVersion(clientMetadata.getSdkVersion());
        this.setDeviceInfo(clientMetadata.getDeviceManufacturer(), clientMetadata.getDeviceModel(), clientMetadata.getDeviceProduct());
        this.setBundleId(clientMetadata.getAppPackageName());
        this.setKeywords(this.mKeywords);
        this.setLocation(this.mLocation);
        this.setTimezone(DateAndTime.getTimeZoneOffsetString());
        this.setOrientation(clientMetadata.getOrientationString());
        this.setDeviceDimensions(clientMetadata.getDeviceDimensions());
        this.setDensity(clientMetadata.getDensity());
        String networkOperator = clientMetadata.getNetworkOperatorForUrl();
        this.setMccCode(networkOperator);
        this.setMncCode(networkOperator);
        this.setIsoCountryCode(clientMetadata.getIsoCountryCode());
        this.setCarrierName(clientMetadata.getNetworkOperatorName());
        this.setNetworkType(clientMetadata.getActiveNetworkType());
        this.setAppVersion(clientMetadata.getAppVersion());
        this.appendAdvertisingInfoTemplates();
    }

    private void addParam(String key, ClientMetadata.MoPubNetworkType value) {
        this.addParam(key, value.toString());
    }

    private int mncPortionLength(String networkOperator) {
        return Math.min(3, networkOperator.length());
    }

    private static int calculateLocationStalenessInMilliseconds(Location location) {
        Preconditions.checkNotNull(location);
        long locationLastUpdatedInMillis = location.getTime();
        long nowInMillis = System.currentTimeMillis();
        return (int)(nowInMillis - locationLastUpdatedInMillis);
    }

    @Deprecated
    public AdUrlGenerator withFacebookSupported(boolean enabled) {
        return this;
    }
}

