/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.os.Build;
import android.support.annotation.NonNull;
import com.mopub.common.ClientMetadata;
import com.mopub.network.AdResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AdReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DATE_FORMAT_PATTERN = "M/d/yy hh:mm:ss a z";
    private final AdResponse mAdResponse;
    private final String mAdUnitId;
    private final String mSdkVersion;
    private final String mDeviceModel;
    private final Locale mDeviceLocale;
    private final String mUdid;

    public AdReport(@NonNull String adUnitId, @NonNull ClientMetadata clientMetadata, @NonNull AdResponse adResponse) {
        this.mAdUnitId = adUnitId;
        this.mSdkVersion = clientMetadata.getSdkVersion();
        this.mDeviceModel = clientMetadata.getDeviceModel();
        this.mDeviceLocale = clientMetadata.getDeviceLocale();
        this.mUdid = clientMetadata.getDeviceId();
        this.mAdResponse = adResponse;
    }

    public String toString() {
        StringBuilder parameters = new StringBuilder();
        this.appendKeyValue(parameters, "sdk_version", this.mSdkVersion);
        this.appendKeyValue(parameters, "creative_id", this.mAdResponse.getDspCreativeId());
        this.appendKeyValue(parameters, "platform_version", Integer.toString(Build.VERSION.SDK_INT));
        this.appendKeyValue(parameters, "device_model", this.mDeviceModel);
        this.appendKeyValue(parameters, "ad_unit_id", this.mAdUnitId);
        this.appendKeyValue(parameters, "device_locale", this.mDeviceLocale == null ? null : this.mDeviceLocale.toString());
        this.appendKeyValue(parameters, "device_id", this.mUdid);
        this.appendKeyValue(parameters, "network_type", this.mAdResponse.getNetworkType());
        this.appendKeyValue(parameters, "platform", "android");
        this.appendKeyValue(parameters, "timestamp", this.getFormattedTimeStamp(this.mAdResponse.getTimestamp()));
        this.appendKeyValue(parameters, "ad_type", this.mAdResponse.getAdType());
        Integer width = this.mAdResponse.getWidth();
        Integer height = this.mAdResponse.getHeight();
        this.appendKeyValue(parameters, "ad_size", "{" + (width == null ? "0" : width) + ", " + (height == null ? "0" : height) + "}");
        return parameters.toString();
    }

    public String getResponseString() {
        return this.mAdResponse.getStringBody();
    }

    private void appendKeyValue(StringBuilder parameters, String key, String value) {
        parameters.append(key);
        parameters.append(" : ");
        parameters.append(value);
        parameters.append("\n");
    }

    private String getFormattedTimeStamp(long timeStamp) {
        if (timeStamp != -1L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
            return dateFormat.format(new Date(timeStamp));
        }
        return null;
    }
}

