package com.mopub.nativeads;

import android.support.annotation.NonNull;

public enum NativeErrorCode {
    EMPTY_AD_RESPONSE("Server returned empty response."),
    INVALID_JSON("Unable to parse JSON response from server."),
    IMAGE_DOWNLOAD_FAILURE("Unable to download images associated with ad."),
    INVALID_REQUEST_URL("Invalid request url."),
    UNEXPECTED_RESPONSE_CODE("Received unexpected response code from server."),
    SERVER_ERROR_RESPONSE_CODE("Server returned erroneous response code."),
    CONNECTION_ERROR("Network is unavailable."),
    UNSPECIFIED("Unspecified error occurred."),

    NETWORK_INVALID_REQUEST("Third-party network received invalid request."),
    NETWORK_TIMEOUT("Third-party network failed to respond in a timely manner."),
    NETWORK_NO_FILL("Third-party network failed to provide an ad."),
    NETWORK_INVALID_STATE("Third-party network failed due to invalid internal state."),

    NATIVE_ADAPTER_CONFIGURATION_ERROR("Custom Event Native was configured incorrectly."),
    NATIVE_ADAPTER_NOT_FOUND("Unable to find Custom Event Native.");

    private final String message;

    private NativeErrorCode(String message) {
        this.message = message;
    }

    @NonNull
    @Override
    public final String toString() {
        return message;
    }
}
