/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.ClickInterface;
import com.mopub.nativeads.ImpressionInterface;
import java.util.HashMap;
import java.util.Map;

public abstract class StaticNativeAd
extends BaseNativeAd
implements ImpressionInterface,
ClickInterface {
    private static final int DEFAULT_IMPRESSION_MIN_TIME_VIEWED_MS = 1000;
    private static final int DEFAULT_IMPRESSION_MIN_PERCENTAGE_VIEWED = 50;
    static final double MIN_STAR_RATING = 0.0;
    static final double MAX_STAR_RATING = 5.0;
    @Nullable
    private String mMainImageUrl;
    @Nullable
    private String mIconImageUrl;
    @Nullable
    private String mClickDestinationUrl;
    @Nullable
    private String mCallToAction;
    @Nullable
    private String mTitle;
    @Nullable
    private String mText;
    @Nullable
    private Double mStarRating;
    @Nullable
    private String mPrivacyInformationIconClickThroughUrl;
    @Nullable
    private String mPrivacyInformationIconImageUrl;
    private boolean mImpressionRecorded;
    private int mImpressionMinTimeViewed = 1000;
    private int mImpressionMinPercentageViewed = 50;
    private Integer mImpressionMinVisiblePx = null;
    @NonNull
    private final Map<String, Object> mExtras = new HashMap<String, Object>();

    @Nullable
    public final String getTitle() {
        return this.mTitle;
    }

    @Nullable
    public final String getText() {
        return this.mText;
    }

    @Nullable
    public final String getMainImageUrl() {
        return this.mMainImageUrl;
    }

    @Nullable
    public final String getIconImageUrl() {
        return this.mIconImageUrl;
    }

    @Nullable
    public final String getCallToAction() {
        return this.mCallToAction;
    }

    @Nullable
    public final Double getStarRating() {
        return this.mStarRating;
    }

    @Nullable
    public final String getPrivacyInformationIconClickThroughUrl() {
        return this.mPrivacyInformationIconClickThroughUrl;
    }

    @Nullable
    public String getPrivacyInformationIconImageUrl() {
        return this.mPrivacyInformationIconImageUrl;
    }

    @Nullable
    public final Object getExtra(@NonNull String key) {
        if (!Preconditions.NoThrow.checkNotNull((Object)key, (String)"getExtra key is not allowed to be null")) {
            return null;
        }
        return this.mExtras.get(key);
    }

    @NonNull
    public final Map<String, Object> getExtras() {
        return new HashMap<String, Object>(this.mExtras);
    }

    @Nullable
    public final String getClickDestinationUrl() {
        return this.mClickDestinationUrl;
    }

    public final void setMainImageUrl(@Nullable String mainImageUrl) {
        this.mMainImageUrl = mainImageUrl;
    }

    public final void setIconImageUrl(@Nullable String iconImageUrl) {
        this.mIconImageUrl = iconImageUrl;
    }

    public final void setClickDestinationUrl(@Nullable String clickDestinationUrl) {
        this.mClickDestinationUrl = clickDestinationUrl;
    }

    public final void setCallToAction(@Nullable String callToAction) {
        this.mCallToAction = callToAction;
    }

    public final void setTitle(@Nullable String title) {
        this.mTitle = title;
    }

    public final void setText(@Nullable String text) {
        this.mText = text;
    }

    public final void setStarRating(@Nullable Double starRating) {
        if (starRating == null) {
            this.mStarRating = null;
        } else if (starRating >= 0.0 && starRating <= 5.0) {
            this.mStarRating = starRating;
        } else {
            MoPubLog.d((String)("Ignoring attempt to set invalid star rating (" + starRating + "). Must be between " + 0.0 + " and " + 5.0 + "."));
        }
    }

    public final void setPrivacyInformationIconClickThroughUrl(@Nullable String privacyInformationIconClickThroughUrl) {
        this.mPrivacyInformationIconClickThroughUrl = privacyInformationIconClickThroughUrl;
    }

    public final void setPrivacyInformationIconImageUrl(@Nullable String privacyInformationIconImageUrl) {
        this.mPrivacyInformationIconImageUrl = privacyInformationIconImageUrl;
    }

    public final void addExtra(@NonNull String key, @Nullable Object value) {
        if (!Preconditions.NoThrow.checkNotNull((Object)key, (String)"addExtra key is not allowed to be null")) {
            return;
        }
        this.mExtras.put(key, value);
    }

    public final void setImpressionMinTimeViewed(int impressionMinTimeViewed) {
        if (impressionMinTimeViewed > 0) {
            this.mImpressionMinTimeViewed = impressionMinTimeViewed;
        } else {
            MoPubLog.d((String)("Ignoring non-positive impressionMinTimeViewed: " + impressionMinTimeViewed));
        }
    }

    public final void setImpressionMinPercentageViewed(int impressionMinPercentageViewed) {
        if (impressionMinPercentageViewed >= 0 && impressionMinPercentageViewed <= 100) {
            this.mImpressionMinPercentageViewed = impressionMinPercentageViewed;
        } else {
            MoPubLog.d((String)("Ignoring impressionMinTimeViewed that's not a percent [0, 100]: " + impressionMinPercentageViewed));
        }
    }

    public final void setImpressionMinVisiblePx(@Nullable Integer impressionMinVisiblePx) {
        if (impressionMinVisiblePx != null && impressionMinVisiblePx > 0) {
            this.mImpressionMinVisiblePx = impressionMinVisiblePx;
        } else {
            MoPubLog.d((String)("Ignoring null or non-positive impressionMinVisiblePx: " + impressionMinVisiblePx));
        }
    }

    @Override
    public void prepare(@NonNull View view) {
    }

    @Override
    public void clear(@NonNull View view) {
    }

    @Override
    public void destroy() {
        this.invalidate();
    }

    @Override
    public void recordImpression(@NonNull View view) {
    }

    @Override
    public final int getImpressionMinPercentageViewed() {
        return this.mImpressionMinPercentageViewed;
    }

    @Override
    public final int getImpressionMinTimeViewed() {
        return this.mImpressionMinTimeViewed;
    }

    @Override
    public final Integer getImpressionMinVisiblePx() {
        return this.mImpressionMinVisiblePx;
    }

    @Override
    public final boolean isImpressionRecorded() {
        return this.mImpressionRecorded;
    }

    @Override
    public final void setImpressionRecorded() {
        this.mImpressionRecorded = true;
    }

    @Override
    public void handleClick(@NonNull View view) {
    }
}

