/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.MoPub;
import java.util.EnumSet;

public class RequestParameters {
    @Nullable
    private final String mKeywords;
    @Nullable
    private final String mUserDataKeywords;
    @Nullable
    private final Location mLocation;
    @Nullable
    private final EnumSet<NativeAdAsset> mDesiredAssets;

    private RequestParameters(@NonNull Builder builder) {
        this.mKeywords = builder.keywords;
        this.mDesiredAssets = builder.desiredAssets;
        boolean canCollectPersonalInformation = MoPub.canCollectPersonalInformation();
        this.mUserDataKeywords = canCollectPersonalInformation ? builder.userDatakeywords : null;
        this.mLocation = canCollectPersonalInformation ? builder.location : null;
    }

    @Nullable
    public final String getKeywords() {
        return this.mKeywords;
    }

    @Nullable
    public final String getUserDataKeywords() {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        return this.mUserDataKeywords;
    }

    @Nullable
    public final Location getLocation() {
        return this.mLocation;
    }

    public final String getDesiredAssets() {
        String result = "";
        if (this.mDesiredAssets != null) {
            result = TextUtils.join((CharSequence)",", (Object[])this.mDesiredAssets.toArray());
        }
        return result;
    }

    public static final class Builder {
        private String keywords;
        private String userDatakeywords;
        private Location location;
        private EnumSet<NativeAdAsset> desiredAssets;

        @NonNull
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        @NonNull
        public final Builder userDataKeywords(String userDataKeywords) {
            this.userDatakeywords = MoPub.canCollectPersonalInformation() ? userDataKeywords : null;
            return this;
        }

        @NonNull
        public final Builder location(Location location) {
            this.location = MoPub.canCollectPersonalInformation() ? location : null;
            return this;
        }

        @NonNull
        public final Builder desiredAssets(EnumSet<NativeAdAsset> desiredAssets) {
            this.desiredAssets = EnumSet.copyOf(desiredAssets);
            return this;
        }

        @NonNull
        public final RequestParameters build() {
            return new RequestParameters(this);
        }
    }

    public static enum NativeAdAsset {
        TITLE("title"),
        TEXT("text"),
        ICON_IMAGE("iconimage"),
        MAIN_IMAGE("mainimage"),
        CALL_TO_ACTION_TEXT("ctatext"),
        STAR_RATING("starrating");

        private final String mAssetName;

        private NativeAdAsset(String assetName) {
            this.mAssetName = assetName;
        }

        @NonNull
        public String toString() {
            return this.mAssetName;
        }
    }
}

