/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestUtils;
import com.mopub.volley.Cache;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Response;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;
import com.mopub.volley.toolbox.JsonRequest;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PositioningRequest
extends JsonRequest<MoPubNativeAdPositioning.MoPubClientPositioning> {
    private static final String FIXED_KEY = "fixed";
    private static final String SECTION_KEY = "section";
    private static final String POSITION_KEY = "position";
    private static final String REPEATING_KEY = "repeating";
    private static final String INTERVAL_KEY = "interval";
    private static final int MAX_VALUE = 65536;
    @NonNull
    private final String mOriginalUrl;
    @NonNull
    private final Context mContext;

    public PositioningRequest(@NonNull Context context, String url, Response.Listener<MoPubNativeAdPositioning.MoPubClientPositioning> listener, Response.ErrorListener errorListener) {
        super(MoPubRequestUtils.chooseMethod((String)url), MoPubRequestUtils.truncateQueryParamsIfPost((String)url), null, listener, errorListener);
        this.mOriginalUrl = url;
        this.mContext = context.getApplicationContext();
    }

    protected void deliverResponse(MoPubNativeAdPositioning.MoPubClientPositioning response) {
        super.deliverResponse((Object)response);
    }

    protected Response<MoPubNativeAdPositioning.MoPubClientPositioning> parseNetworkResponse(NetworkResponse response) {
        if (response.statusCode != 200) {
            return Response.error((VolleyError)new VolleyError(response));
        }
        if (response.data.length == 0) {
            return Response.error((VolleyError)new VolleyError("Empty positioning response", (Throwable)new JSONException("Empty response")));
        }
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)this.parseJson(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new VolleyError("Couldn't parse JSON from Charset", (Throwable)e));
        }
        catch (JSONException e) {
            return Response.error((VolleyError)new VolleyError("JSON Parsing Error", (Throwable)e));
        }
        catch (MoPubNetworkError e) {
            return Response.error((VolleyError)e);
        }
    }

    @NonNull
    @VisibleForTesting
    MoPubNativeAdPositioning.MoPubClientPositioning parseJson(@NonNull String jsonString) throws JSONException, MoPubNetworkError {
        JSONObject jsonObject = new JSONObject(jsonString);
        String error = jsonObject.optString("error", null);
        if (error != null) {
            if (error.equalsIgnoreCase("WARMING_UP")) {
                throw new MoPubNetworkError(MoPubNetworkError.Reason.WARMING_UP);
            }
            throw new JSONException(error);
        }
        JSONArray fixed = jsonObject.optJSONArray(FIXED_KEY);
        JSONObject repeating = jsonObject.optJSONObject(REPEATING_KEY);
        if (fixed == null && repeating == null) {
            throw new JSONException("Must contain fixed or repeating positions");
        }
        MoPubNativeAdPositioning.MoPubClientPositioning positioning = new MoPubNativeAdPositioning.MoPubClientPositioning();
        if (fixed != null) {
            this.parseFixedJson(fixed, positioning);
        }
        if (repeating != null) {
            this.parseRepeatingJson(repeating, positioning);
        }
        return positioning;
    }

    private void parseFixedJson(@NonNull JSONArray fixed, @NonNull MoPubNativeAdPositioning.MoPubClientPositioning positioning) throws JSONException {
        for (int i = 0; i < fixed.length(); ++i) {
            JSONObject positionObject = fixed.getJSONObject(i);
            int section = positionObject.optInt(SECTION_KEY, 0);
            if (section < 0) {
                throw new JSONException("Invalid section " + section + " in JSON response");
            }
            if (section > 0) continue;
            int position = positionObject.getInt(POSITION_KEY);
            if (position < 0 || position > 65536) {
                throw new JSONException("Invalid position " + position + " in JSON response");
            }
            positioning.addFixedPosition(position);
        }
    }

    private void parseRepeatingJson(@NonNull JSONObject repeatingObject, @NonNull MoPubNativeAdPositioning.MoPubClientPositioning positioning) throws JSONException {
        int interval = repeatingObject.getInt(INTERVAL_KEY);
        if (interval < 2 || interval > 65536) {
            throw new JSONException("Invalid interval " + interval + " in JSON response");
        }
        positioning.enableRepeatingPositions(interval);
    }

    protected Map<String, String> getParams() {
        if (!MoPubRequestUtils.isMoPubRequest((String)this.getUrl())) {
            return null;
        }
        return MoPubRequestUtils.convertQueryToMap((Context)this.mContext, (String)this.mOriginalUrl);
    }

    public byte[] getBody() {
        String body = MoPubRequestUtils.generateBodyFromParams(this.getParams(), (String)this.getUrl());
        if (body == null) {
            return null;
        }
        return body.getBytes();
    }
}

