/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.MoPub;
import com.mopub.nativeads.RequestParameters;

class NativeUrlGenerator
extends AdUrlGenerator {
    @Nullable
    private String mDesiredAssets;
    @Nullable
    private String mSequenceNumber;

    NativeUrlGenerator(Context context) {
        super(context);
    }

    @NonNull
    public NativeUrlGenerator withAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    @NonNull
    NativeUrlGenerator withRequest(@Nullable RequestParameters requestParameters) {
        if (requestParameters != null) {
            boolean canCollectPersonalInformation = MoPub.canCollectPersonalInformation();
            this.mUserDataKeywords = canCollectPersonalInformation ? requestParameters.getUserDataKeywords() : null;
            this.mLocation = canCollectPersonalInformation ? requestParameters.getLocation() : null;
            this.mKeywords = requestParameters.getKeywords();
            this.mDesiredAssets = requestParameters.getDesiredAssets();
        }
        return this;
    }

    @NonNull
    NativeUrlGenerator withSequenceNumber(int sequenceNumber) {
        this.mSequenceNumber = String.valueOf(sequenceNumber);
        return this;
    }

    public String generateUrlString(String serverHostname) {
        this.initUrlString(serverHostname, "/m/ad");
        ClientMetadata clientMetadata = ClientMetadata.getInstance((Context)this.mContext);
        this.addBaseParams(clientMetadata);
        this.setDesiredAssets();
        this.setSequenceNumber();
        return this.getFinalUrlString();
    }

    private void setSequenceNumber() {
        if (!TextUtils.isEmpty((CharSequence)this.mSequenceNumber)) {
            this.addParam("MAGIC_NO", this.mSequenceNumber);
        }
    }

    private void setDesiredAssets() {
        if (!TextUtils.isEmpty((CharSequence)this.mDesiredAssets)) {
            this.addParam("assets", this.mDesiredAssets);
        }
    }
}

