/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Drawables;
import com.mopub.nativeads.NativeImageHelper;
import java.util.Map;

public class NativeRendererHelper {
    public static void addTextView(@Nullable TextView textView, @Nullable String contents) {
        if (textView == null) {
            MoPubLog.d((String)("Attempted to add text (" + contents + ") to null TextView."));
            return;
        }
        textView.setText(null);
        if (contents == null) {
            MoPubLog.d((String)"Attempted to set TextView contents to null.");
        } else {
            textView.setText((CharSequence)contents);
        }
    }

    public static void addPrivacyInformationIcon(ImageView privacyInformationIconImageView, String privacyInformationImageUrl, final String privacyInformationClickthroughUrl) {
        if (privacyInformationIconImageView == null) {
            return;
        }
        if (privacyInformationClickthroughUrl == null) {
            privacyInformationIconImageView.setImageDrawable(null);
            privacyInformationIconImageView.setOnClickListener(null);
            privacyInformationIconImageView.setVisibility(4);
            return;
        }
        final Context context = privacyInformationIconImageView.getContext();
        if (context == null) {
            return;
        }
        if (privacyInformationImageUrl == null) {
            privacyInformationIconImageView.setImageDrawable(Drawables.NATIVE_PRIVACY_INFORMATION_ICON.createDrawable(context));
        } else {
            NativeImageHelper.loadImageView(privacyInformationImageUrl, privacyInformationIconImageView);
        }
        privacyInformationIconImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new UrlHandler.Builder().withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK}).build().handleUrl(context, privacyInformationClickthroughUrl);
            }
        });
        privacyInformationIconImageView.setVisibility(0);
    }

    public static void addCtaButton(@Nullable TextView ctaTextView, final @Nullable View rootView, @Nullable String contents) {
        NativeRendererHelper.addTextView(ctaTextView, contents);
        if (ctaTextView == null || rootView == null) {
            return;
        }
        ctaTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                rootView.performClick();
            }
        });
    }

    public static void updateExtras(@Nullable View mainView, @NonNull Map<String, Integer> extrasIds, @NonNull Map<String, Object> extras) {
        if (mainView == null) {
            MoPubLog.w((String)"Attempted to bind extras on a null main view.");
            return;
        }
        for (String key : extrasIds.keySet()) {
            int resourceId = extrasIds.get(key);
            View view = mainView.findViewById(resourceId);
            Object content = extras.get(key);
            if (view instanceof ImageView) {
                ((ImageView)view).setImageDrawable(null);
                Object object = extras.get(key);
                if (object == null || !(object instanceof String)) continue;
                NativeImageHelper.loadImageView((String)object, (ImageView)view);
                continue;
            }
            if (view instanceof TextView) {
                ((TextView)view).setText(null);
                if (!(content instanceof String)) continue;
                NativeRendererHelper.addTextView((TextView)view, (String)content);
                continue;
            }
            MoPubLog.d((String)("View bound to " + key + " should be an instance of TextView or ImageView."));
        }
    }
}

