/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.MoPubNativeAdLoadedListener;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.nativeads.MoPubRecyclerViewHolder;
import com.mopub.nativeads.MoPubStreamAdPlacer;
import com.mopub.nativeads.NativeAd;
import com.mopub.nativeads.RequestParameters;
import java.util.List;
import java.util.WeakHashMap;

public final class MoPubRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    static final int NATIVE_AD_VIEW_TYPE_BASE = -56;
    @NonNull
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver;
    @Nullable
    private RecyclerView mRecyclerView;
    @NonNull
    private final MoPubStreamAdPlacer mStreamAdPlacer;
    @NonNull
    private final RecyclerView.Adapter mOriginalAdapter;
    @NonNull
    private final VisibilityTracker mVisibilityTracker;
    @NonNull
    private final WeakHashMap<View, Integer> mViewPositionMap;
    @NonNull
    private ContentChangeStrategy mStrategy = ContentChangeStrategy.INSERT_AT_END;
    @Nullable
    private MoPubNativeAdLoadedListener mAdLoadedListener;

    public MoPubRecyclerAdapter(@NonNull Activity activity, @NonNull RecyclerView.Adapter originalAdapter) {
        this(activity, originalAdapter, MoPubNativeAdPositioning.serverPositioning());
    }

    public MoPubRecyclerAdapter(@NonNull Activity activity, @NonNull RecyclerView.Adapter originalAdapter, @NonNull MoPubNativeAdPositioning.MoPubServerPositioning adPositioning) {
        this(new MoPubStreamAdPlacer(activity, adPositioning), originalAdapter, new VisibilityTracker((Context)activity));
    }

    public MoPubRecyclerAdapter(@NonNull Activity activity, @NonNull RecyclerView.Adapter originalAdapter, @NonNull MoPubNativeAdPositioning.MoPubClientPositioning adPositioning) {
        this(new MoPubStreamAdPlacer(activity, adPositioning), originalAdapter, new VisibilityTracker((Context)activity));
    }

    @VisibleForTesting
    MoPubRecyclerAdapter(@NonNull MoPubStreamAdPlacer streamAdPlacer, @NonNull RecyclerView.Adapter originalAdapter, @NonNull VisibilityTracker visibilityTracker) {
        this.mViewPositionMap = new WeakHashMap();
        this.mOriginalAdapter = originalAdapter;
        this.mVisibilityTracker = visibilityTracker;
        this.mVisibilityTracker.setVisibilityTrackerListener(new VisibilityTracker.VisibilityTrackerListener(){

            public void onVisibilityChanged(List<View> visibleViews, List<View> invisibleViews) {
                MoPubRecyclerAdapter.this.handleVisibilityChanged(visibleViews, invisibleViews);
            }
        });
        this.setHasStableIdsInternal(this.mOriginalAdapter.hasStableIds());
        this.mStreamAdPlacer = streamAdPlacer;
        this.mStreamAdPlacer.setAdLoadedListener(new MoPubNativeAdLoadedListener(){

            @Override
            public void onAdLoaded(int position) {
                MoPubRecyclerAdapter.this.handleAdLoaded(position);
            }

            @Override
            public void onAdRemoved(int position) {
                MoPubRecyclerAdapter.this.handleAdRemoved(position);
            }
        });
        this.mStreamAdPlacer.setItemCount(this.mOriginalAdapter.getItemCount());
        this.mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                MoPubRecyclerAdapter.this.mStreamAdPlacer.setItemCount(MoPubRecyclerAdapter.this.mOriginalAdapter.getItemCount());
                MoPubRecyclerAdapter.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                int adjustedEndPosition = MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedPosition(positionStart + itemCount - 1);
                int adjustedStartPosition = MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedPosition(positionStart);
                int adjustedCount = adjustedEndPosition - adjustedStartPosition + 1;
                MoPubRecyclerAdapter.this.notifyItemRangeChanged(adjustedStartPosition, adjustedCount);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                boolean addingToEnd;
                int adjustedStartPosition = MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedPosition(positionStart);
                int newOriginalCount = MoPubRecyclerAdapter.this.mOriginalAdapter.getItemCount();
                MoPubRecyclerAdapter.this.mStreamAdPlacer.setItemCount(newOriginalCount);
                boolean bl = addingToEnd = positionStart + itemCount >= newOriginalCount;
                if (ContentChangeStrategy.KEEP_ADS_FIXED == MoPubRecyclerAdapter.this.mStrategy || ContentChangeStrategy.INSERT_AT_END == MoPubRecyclerAdapter.this.mStrategy && addingToEnd) {
                    MoPubRecyclerAdapter.this.notifyDataSetChanged();
                } else {
                    for (int i = 0; i < itemCount; ++i) {
                        MoPubRecyclerAdapter.this.mStreamAdPlacer.insertItem(positionStart);
                    }
                    MoPubRecyclerAdapter.this.notifyItemRangeInserted(adjustedStartPosition, itemCount);
                }
            }

            public void onItemRangeRemoved(int positionStart, int itemsRemoved) {
                boolean removingFromEnd;
                int adjustedStartPosition = MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedPosition(positionStart);
                int newOriginalCount = MoPubRecyclerAdapter.this.mOriginalAdapter.getItemCount();
                MoPubRecyclerAdapter.this.mStreamAdPlacer.setItemCount(newOriginalCount);
                boolean bl = removingFromEnd = positionStart + itemsRemoved >= newOriginalCount;
                if (ContentChangeStrategy.KEEP_ADS_FIXED == MoPubRecyclerAdapter.this.mStrategy || ContentChangeStrategy.INSERT_AT_END == MoPubRecyclerAdapter.this.mStrategy && removingFromEnd) {
                    MoPubRecyclerAdapter.this.notifyDataSetChanged();
                } else {
                    int oldAdjustedCount = MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedCount(newOriginalCount + itemsRemoved);
                    for (int i = 0; i < itemsRemoved; ++i) {
                        MoPubRecyclerAdapter.this.mStreamAdPlacer.removeItem(positionStart);
                    }
                    int itemsRemovedIncludingAds = oldAdjustedCount - MoPubRecyclerAdapter.this.mStreamAdPlacer.getAdjustedCount(newOriginalCount);
                    MoPubRecyclerAdapter.this.notifyItemRangeRemoved(adjustedStartPosition -= itemsRemovedIncludingAds - itemsRemoved, itemsRemovedIncludingAds);
                }
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                MoPubRecyclerAdapter.this.notifyDataSetChanged();
            }
        };
        this.mOriginalAdapter.registerAdapterDataObserver(this.mAdapterDataObserver);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    public void setAdLoadedListener(@Nullable MoPubNativeAdLoadedListener listener) {
        this.mAdLoadedListener = listener;
    }

    public void registerAdRenderer(@NonNull MoPubAdRenderer adRenderer) {
        if (!Preconditions.NoThrow.checkNotNull((Object)adRenderer, (String)"Cannot register a null adRenderer")) {
            return;
        }
        this.mStreamAdPlacer.registerAdRenderer(adRenderer);
    }

    public void loadAds(@NonNull String adUnitId) {
        this.mStreamAdPlacer.loadAds(adUnitId);
    }

    public void loadAds(@NonNull String adUnitId, @Nullable RequestParameters requestParameters) {
        this.mStreamAdPlacer.loadAds(adUnitId, requestParameters);
    }

    public static int computeScrollOffset(@NonNull LinearLayoutManager linearLayoutManager, @Nullable RecyclerView.ViewHolder holder) {
        if (holder == null) {
            return 0;
        }
        View view = holder.itemView;
        int offset = 0;
        if (linearLayoutManager.canScrollVertically()) {
            offset = linearLayoutManager.getStackFromEnd() ? view.getBottom() : view.getTop();
        } else if (linearLayoutManager.canScrollHorizontally()) {
            offset = linearLayoutManager.getStackFromEnd() ? view.getRight() : view.getLeft();
        }
        return offset;
    }

    public void refreshAds(@NonNull String adUnitId) {
        this.refreshAds(adUnitId, null);
    }

    public void refreshAds(@NonNull String adUnitId, @Nullable RequestParameters requestParameters) {
        if (this.mRecyclerView == null) {
            MoPubLog.w((String)"This adapter is not attached to a RecyclerView and cannot be refreshed.");
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager == null) {
            MoPubLog.w((String)"Can't refresh ads when there is no layout manager on a RecyclerView.");
            return;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            int endOfRange;
            int startOfRange;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int firstPosition = linearLayoutManager.findFirstVisibleItemPosition();
            RecyclerView.ViewHolder holder = this.mRecyclerView.findViewHolderForLayoutPosition(firstPosition);
            int scrollOffset = MoPubRecyclerAdapter.computeScrollOffset(linearLayoutManager, holder);
            for (startOfRange = Math.max(0, firstPosition - 1); this.mStreamAdPlacer.isAd(startOfRange) && startOfRange > 0; --startOfRange) {
            }
            int itemCount = this.getItemCount();
            for (endOfRange = linearLayoutManager.findLastVisibleItemPosition(); this.mStreamAdPlacer.isAd(endOfRange) && endOfRange < itemCount - 1; ++endOfRange) {
            }
            int originalStartOfRange = this.mStreamAdPlacer.getOriginalPosition(startOfRange);
            int originalEndOfRange = this.mStreamAdPlacer.getOriginalPosition(endOfRange);
            int endCount = this.mOriginalAdapter.getItemCount();
            this.mStreamAdPlacer.removeAdsInRange(originalEndOfRange, endCount);
            int numAdsRemoved = this.mStreamAdPlacer.removeAdsInRange(0, originalStartOfRange);
            if (numAdsRemoved > 0) {
                linearLayoutManager.scrollToPositionWithOffset(firstPosition - numAdsRemoved, scrollOffset);
            }
            this.loadAds(adUnitId, requestParameters);
        } else {
            MoPubLog.w((String)"This LayoutManager can't be refreshed.");
        }
    }

    public void clearAds() {
        this.mStreamAdPlacer.clearAds();
    }

    public boolean isAd(int position) {
        return this.mStreamAdPlacer.isAd(position);
    }

    public int getAdjustedPosition(int originalPosition) {
        return this.mStreamAdPlacer.getAdjustedPosition(originalPosition);
    }

    public int getOriginalPosition(int position) {
        return this.mStreamAdPlacer.getOriginalPosition(position);
    }

    public void setContentChangeStrategy(@NonNull ContentChangeStrategy strategy) {
        if (!Preconditions.NoThrow.checkNotNull((Object)((Object)strategy))) {
            return;
        }
        this.mStrategy = strategy;
    }

    public int getItemCount() {
        return this.mStreamAdPlacer.getAdjustedCount(this.mOriginalAdapter.getItemCount());
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType >= -56 && viewType <= -56 + this.mStreamAdPlacer.getAdViewTypeCount()) {
            MoPubAdRenderer adRenderer = this.mStreamAdPlacer.getAdRendererForViewType(viewType - -56);
            if (adRenderer == null) {
                MoPubLog.w((String)"No view binder was registered for ads in MoPubRecyclerAdapter.");
                return null;
            }
            return new MoPubRecyclerViewHolder(adRenderer.createAdView((Context)((Activity)parent.getContext()), parent));
        }
        return this.mOriginalAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Object adResponse = this.mStreamAdPlacer.getAdData(position);
        if (adResponse != null) {
            this.mStreamAdPlacer.bindAdView((NativeAd)adResponse, holder.itemView);
            return;
        }
        this.mViewPositionMap.put(holder.itemView, position);
        this.mVisibilityTracker.addView(holder.itemView, 0, null);
        this.mOriginalAdapter.onBindViewHolder(holder, this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public int getItemViewType(int position) {
        int type = this.mStreamAdPlacer.getAdViewType(position);
        if (type != 0) {
            return -56 + type;
        }
        return this.mOriginalAdapter.getItemViewType(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public void setHasStableIds(boolean hasStableIds) {
        this.setHasStableIdsInternal(hasStableIds);
        this.mOriginalAdapter.unregisterAdapterDataObserver(this.mAdapterDataObserver);
        this.mOriginalAdapter.setHasStableIds(hasStableIds);
        this.mOriginalAdapter.registerAdapterDataObserver(this.mAdapterDataObserver);
    }

    public void destroy() {
        this.mOriginalAdapter.unregisterAdapterDataObserver(this.mAdapterDataObserver);
        this.mStreamAdPlacer.destroy();
        this.mVisibilityTracker.destroy();
    }

    public long getItemId(int position) {
        if (!this.mOriginalAdapter.hasStableIds()) {
            return -1L;
        }
        Object adData = this.mStreamAdPlacer.getAdData(position);
        if (adData != null) {
            return -System.identityHashCode(adData);
        }
        return this.mOriginalAdapter.getItemId(this.mStreamAdPlacer.getOriginalPosition(position));
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (holder instanceof MoPubRecyclerViewHolder) {
            return super.onFailedToRecycleView(holder);
        }
        return this.mOriginalAdapter.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof MoPubRecyclerViewHolder) {
            super.onViewAttachedToWindow(holder);
            return;
        }
        this.mOriginalAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof MoPubRecyclerViewHolder) {
            super.onViewDetachedFromWindow(holder);
            return;
        }
        this.mOriginalAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (holder instanceof MoPubRecyclerViewHolder) {
            super.onViewRecycled(holder);
            return;
        }
        this.mOriginalAdapter.onViewRecycled(holder);
    }

    @VisibleForTesting
    void handleAdLoaded(int position) {
        if (this.mAdLoadedListener != null) {
            this.mAdLoadedListener.onAdLoaded(position);
        }
        this.notifyItemInserted(position);
    }

    @VisibleForTesting
    void handleAdRemoved(int position) {
        if (this.mAdLoadedListener != null) {
            this.mAdLoadedListener.onAdRemoved(position);
        }
        this.notifyItemRemoved(position);
    }

    private void handleVisibilityChanged(List<View> visibleViews, List<View> invisibleViews) {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (View view : visibleViews) {
            Integer pos = this.mViewPositionMap.get(view);
            if (pos == null) continue;
            min = Math.min(pos, min);
            max = Math.max(pos, max);
        }
        this.mStreamAdPlacer.placeAdsInRange(min, max + 1);
    }

    private void setHasStableIdsInternal(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
    }

    public static enum ContentChangeStrategy {
        INSERT_AT_END,
        MOVE_ALL_ADS_WITH_CONTENT,
        KEEP_ADS_FIXED;

    }
}

