/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.factories.CustomEventNativeFactory;
import com.mopub.network.AdResponse;
import java.util.Map;

final class CustomEventNativeAdapter {
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final Runnable mTimeout;
    @Nullable
    private CustomEventNative customEventNative;
    @NonNull
    private CustomEventNative.CustomEventNativeListener mExternalListener;
    private volatile boolean mCompleted;

    CustomEventNativeAdapter(@NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
        Preconditions.checkNotNull((Object)customEventNativeListener);
        this.mExternalListener = customEventNativeListener;
        this.mCompleted = false;
        this.mHandler = new Handler();
        this.mTimeout = new Runnable(){

            @Override
            public void run() {
                if (CustomEventNativeAdapter.this.mCompleted) {
                    return;
                }
                MoPubLog.d((String)("Timeout loading native ad content. " + CustomEventNativeAdapter.this.toString()));
                CustomEventNativeAdapter.this.stopLoading();
                CustomEventNativeAdapter.this.mExternalListener.onNativeAdFailed(NativeErrorCode.NETWORK_TIMEOUT);
            }
        };
    }

    public void loadNativeAd(@NonNull Context context, @NonNull Map<String, Object> localExtras, @NonNull AdResponse adResponse) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(localExtras);
        Preconditions.checkNotNull((Object)adResponse);
        String customEventNativeClassName = adResponse.getCustomEventClassName();
        MoPubLog.d((String)("Attempting to invoke custom event: " + customEventNativeClassName));
        try {
            this.customEventNative = CustomEventNativeFactory.create(customEventNativeClassName);
        }
        catch (Exception e) {
            MoPubLog.e((String)("Failed to load Custom Event Native class: " + customEventNativeClassName));
            this.mExternalListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
            return;
        }
        if (adResponse.hasJson()) {
            localExtras.put("com_mopub_native_json", adResponse.getJsonBody());
        }
        localExtras.put("click-tracking-url", adResponse.getClickTrackingUrl());
        try {
            this.customEventNative.loadNativeAd(context, this.createListener(), localExtras, adResponse.getServerExtras());
            long timeoutMS = adResponse.getAdTimeoutMillis(30000).intValue();
            this.mHandler.postDelayed(this.mTimeout, timeoutMS);
        }
        catch (Exception e) {
            MoPubLog.w((String)"Loading custom event native threw an error.", (Throwable)e);
            this.mExternalListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_NOT_FOUND);
        }
    }

    @NonNull
    private CustomEventNative.CustomEventNativeListener createListener() {
        return new CustomEventNative.CustomEventNativeListener(){

            @Override
            public void onNativeAdLoaded(BaseNativeAd nativeAd) {
                if (CustomEventNativeAdapter.this.mCompleted) {
                    return;
                }
                CustomEventNativeAdapter.this.invalidate();
                CustomEventNativeAdapter.this.mExternalListener.onNativeAdLoaded(nativeAd);
            }

            @Override
            public void onNativeAdFailed(NativeErrorCode errorCode) {
                if (CustomEventNativeAdapter.this.mCompleted) {
                    return;
                }
                CustomEventNativeAdapter.this.invalidate();
                CustomEventNativeAdapter.this.mExternalListener.onNativeAdFailed(errorCode);
            }
        };
    }

    void stopLoading() {
        try {
            if (this.customEventNative != null) {
                this.customEventNative.onInvalidate();
            }
        }
        catch (Exception e) {
            MoPubLog.e((String)e.toString());
        }
        this.invalidate();
    }

    private synchronized void invalidate() {
        if (!this.mCompleted) {
            this.mCompleted = true;
            this.mHandler.removeCallbacks(this.mTimeout);
            this.customEventNative = null;
        }
    }
}

